/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.repository.QualityProfileLoader;
import org.sonar.scanner.scan.ScanProperties;
import org.sonar.scanner.util.ScannerUtils;
import org.sonarqube.ws.Qualityprofiles;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpException;

public class DefaultQualityProfileLoader
implements QualityProfileLoader {
    private static final String WS_URL = "/api/qualityprofiles/search.protobuf";
    private final ScannerWsClient wsClient;
    private final ScanProperties properties;

    public DefaultQualityProfileLoader(ScanProperties properties, ScannerWsClient wsClient) {
        this.properties = properties;
        this.wsClient = wsClient;
    }

    private List<Qualityprofiles.SearchWsResponse.QualityProfile> loadDefault() {
        StringBuilder url = new StringBuilder("/api/qualityprofiles/search.protobuf?defaults=true");
        return this.handleErrors(url, () -> "Failed to load the default quality profiles", false);
    }

    @Override
    public List<Qualityprofiles.SearchWsResponse.QualityProfile> load(String projectKey) {
        StringBuilder url = new StringBuilder("/api/qualityprofiles/search.protobuf?projectKey=").append(ScannerUtils.encodeForUrl(projectKey));
        return this.handleErrors(url, () -> String.format("Failed to load the quality profiles of project '%s'", projectKey), true);
    }

    private List<Qualityprofiles.SearchWsResponse.QualityProfile> handleErrors(StringBuilder url, Supplier<String> errorMsg, boolean tryLoadDefault) {
        try {
            return this.doLoad(url);
        }
        catch (HttpException e) {
            if (e.code() == 404) {
                if (tryLoadDefault) {
                    return this.loadDefault();
                }
                throw MessageException.of(errorMsg.get() + ": " + ScannerWsClient.createErrorMessage(e));
            }
            throw new IllegalStateException(errorMsg.get() + ": " + ScannerWsClient.createErrorMessage(e));
        }
        catch (MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(errorMsg.get(), e);
        }
    }

    private List<Qualityprofiles.SearchWsResponse.QualityProfile> doLoad(StringBuilder url) throws IOException {
        this.properties.organizationKey().ifPresent(k -> url.append("&organization=").append(ScannerUtils.encodeForUrl(k)));
        Map<String, Qualityprofiles.SearchWsResponse.QualityProfile> result = this.call(url.toString());
        if (result.isEmpty()) {
            throw MessageException.of("No quality profiles have been found, you probably don't have any language plugin installed.");
        }
        return new ArrayList<Qualityprofiles.SearchWsResponse.QualityProfile>(result.values());
    }

    private Map<String, Qualityprofiles.SearchWsResponse.QualityProfile> call(String url) throws IOException {
        GetRequest getRequest = new GetRequest(url);
        try (InputStream is = this.wsClient.call(getRequest).contentStream();){
            Qualityprofiles.SearchWsResponse profiles = Qualityprofiles.SearchWsResponse.parseFrom(is);
            List<Qualityprofiles.SearchWsResponse.QualityProfile> profilesList = profiles.getProfilesList();
            Map map = profilesList.stream().collect(Collectors.toMap(Qualityprofiles.SearchWsResponse.QualityProfile::getLanguage, Function.identity(), DefaultQualityProfileLoader.throwingMerger(), LinkedHashMap::new));
            return map;
        }
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

