/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.scan.DefaultInputModuleHierarchy;
import org.sonar.scanner.scan.filesystem.ScannerComponentIdGenerator;

public class InputModuleHierarchyProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(InputModuleHierarchyProvider.class);
    private DefaultInputModuleHierarchy hierarchy = null;

    public DefaultInputModuleHierarchy provide(ScannerComponentIdGenerator scannerComponentIdGenerator, DefaultInputProject project) {
        if (this.hierarchy == null) {
            LOG.debug("Creating module hierarchy");
            DefaultInputModule root = InputModuleHierarchyProvider.createModule(project.definition(), project.scannerId());
            Map<DefaultInputModule, DefaultInputModule> parents = InputModuleHierarchyProvider.createChildren(root, scannerComponentIdGenerator, new HashMap<DefaultInputModule, DefaultInputModule>());
            this.hierarchy = parents.isEmpty() ? new DefaultInputModuleHierarchy(root) : new DefaultInputModuleHierarchy(root, parents);
        }
        return this.hierarchy;
    }

    private static Map<DefaultInputModule, DefaultInputModule> createChildren(DefaultInputModule parent, ScannerComponentIdGenerator scannerComponentIdGenerator, Map<DefaultInputModule, DefaultInputModule> parents) {
        for (ProjectDefinition def : parent.definition().getSubProjects()) {
            DefaultInputModule child = InputModuleHierarchyProvider.createModule(def, scannerComponentIdGenerator.getAsInt());
            parents.put(child, parent);
            InputModuleHierarchyProvider.createChildren(child, scannerComponentIdGenerator, parents);
        }
        return parents;
    }

    private static DefaultInputModule createModule(ProjectDefinition def, int scannerComponentId) {
        LOG.debug("  Init module '{}'", (Object)def.getName());
        DefaultInputModule module = new DefaultInputModule(def, scannerComponentId);
        LOG.debug("    Base dir: {}", (Object)module.getBaseDir().toAbsolutePath().toString());
        LOG.debug("    Working dir: {}", (Object)module.getWorkDir().toAbsolutePath().toString());
        LOG.debug("    Module global encoding: {}, default locale: {}", (Object)module.getEncoding().displayName(), (Object)Locale.getDefault());
        return module;
    }
}

