/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.Locale;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.scan.ProjectBuildersExecutor;
import org.sonar.scanner.scan.ProjectReactorValidator;
import org.sonar.scanner.scan.filesystem.ScannerComponentIdGenerator;

public class InputProjectProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(DefaultInputModule.class);
    private DefaultInputProject project = null;

    public DefaultInputProject provide(ProjectBuildersExecutor projectBuildersExecutor, ProjectReactorValidator validator, ProjectReactor projectReactor, ScannerComponentIdGenerator scannerComponentIdGenerator) {
        if (this.project == null) {
            projectBuildersExecutor.execute(projectReactor);
            validator.validate(projectReactor);
            this.project = new DefaultInputProject(projectReactor.getRoot(), scannerComponentIdGenerator.getAsInt());
            LOG.info("Project key: {}", (Object)this.project.key());
            LOG.info("Base dir: {}", (Object)this.project.getBaseDir().toAbsolutePath().toString());
            LOG.info("Working dir: {}", (Object)this.project.getWorkDir().toAbsolutePath().toString());
            LOG.debug("Project global encoding: {}, default locale: {}", (Object)this.project.getEncoding().displayName(), (Object)Locale.getDefault());
        }
        return this.project;
    }
}

