/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import org.picocontainer.Startable;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class ModuleIndexer
implements Startable {
    private final InputModuleHierarchy moduleHierarchy;
    private final InputComponentStore componentStore;

    public ModuleIndexer(InputComponentStore componentStore, InputModuleHierarchy moduleHierarchy) {
        this.componentStore = componentStore;
        this.moduleHierarchy = moduleHierarchy;
    }

    @Override
    public void start() {
        DefaultInputModule root = this.moduleHierarchy.root();
        this.componentStore.put(root);
        this.indexChildren(root);
    }

    private void indexChildren(DefaultInputModule parent) {
        for (DefaultInputModule module : this.moduleHierarchy.children(parent)) {
            this.componentStore.put(module);
            this.indexChildren(module);
        }
    }

    @Override
    public void stop() {
    }
}

