/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.nio.file.Path;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ScmChangedFiles {
    @Nullable
    private final Collection<Path> fileCollection;

    public ScmChangedFiles(@Nullable Collection<Path> changedFiles) {
        this.fileCollection = changedFiles;
    }

    public boolean isChanged(Path file) {
        if (!this.isValid()) {
            throw new IllegalStateException("Scm didn't provide valid data");
        }
        return this.fileCollection.contains(file);
    }

    public boolean isValid() {
        return this.fileCollection != null;
    }

    @CheckForNull
    Collection<Path> get() {
        return this.fileCollection;
    }
}

