/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.internal.DefaultSensorDescriptor;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.scanner.sensor.AbstractSensorOptimizer;

public abstract class AbstractSensorWrapper<G extends ProjectSensor> {
    private final G wrappedSensor;
    private final SensorContext context;
    private final DefaultSensorDescriptor descriptor;
    private final AbstractSensorOptimizer optimizer;

    public AbstractSensorWrapper(G sensor, SensorContext context, AbstractSensorOptimizer optimizer) {
        this.wrappedSensor = sensor;
        this.optimizer = optimizer;
        this.context = context;
        this.descriptor = new DefaultSensorDescriptor();
        sensor.describe(this.descriptor);
        if (this.descriptor.name() == null) {
            this.descriptor.name(sensor.getClass().getName());
        }
    }

    public boolean shouldExecute() {
        return this.optimizer.shouldExecute(this.descriptor);
    }

    public void analyse() {
        this.wrappedSensor.execute(this.context);
    }

    public G wrappedSensor() {
        return this.wrappedSensor;
    }

    public String toString() {
        return this.descriptor.name();
    }

    public boolean isGlobal() {
        return this.descriptor.isGlobal();
    }
}

