/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.logs.Profiler;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.sensor.ProjectSensorExtensionDictionnary;
import org.sonar.scanner.sensor.ProjectSensorWrapper;

public class ProjectSensorsExecutor {
    private static final Logger LOG = Loggers.get(ProjectSensorsExecutor.class);
    private static final Profiler profiler = Profiler.create(LOG);
    private final ProjectSensorExtensionDictionnary selector;
    private final ScannerPluginRepository pluginRepo;

    public ProjectSensorsExecutor(ProjectSensorExtensionDictionnary selector, ScannerPluginRepository pluginRepo) {
        this.selector = selector;
        this.pluginRepo = pluginRepo;
    }

    public void execute() {
        List<ProjectSensorWrapper> sensors = this.selector.selectSensors();
        LOG.debug("Sensors : {}", (Object)sensors.stream().map(Object::toString).collect(Collectors.joining(" -> ")));
        for (ProjectSensorWrapper sensor : sensors) {
            String sensorName = this.getSensorName(sensor);
            profiler.startInfo("Sensor " + sensorName);
            sensor.analyse();
            profiler.stopInfo();
        }
    }

    private String getSensorName(ProjectSensorWrapper sensor) {
        ClassLoader cl = ProjectSensorsExecutor.getSensorClassLoader(sensor);
        String pluginKey = this.pluginRepo.getPluginKey(cl);
        if (pluginKey != null) {
            return sensor.toString() + " [" + pluginKey + "]";
        }
        return sensor.toString();
    }

    private static ClassLoader getSensorClassLoader(ProjectSensorWrapper sensor) {
        return sensor.wrappedSensor().getClass().getClassLoader();
    }
}

