/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;

public final class PluginUpdate {
    private Status status = Status.INCOMPATIBLE;
    private Release release;
    private List<Release> dependencies = Lists.newArrayList();

    public static PluginUpdate createWithStatus(Release pluginRelease, Status status) {
        PluginUpdate update = new PluginUpdate();
        update.setRelease(pluginRelease);
        update.setStatus(status);
        return update;
    }

    public static PluginUpdate createForPluginRelease(Release pluginRelease, Version sonarVersion) {
        PluginUpdate update = new PluginUpdate();
        update.setRelease(pluginRelease);
        if (pluginRelease.supportSonarVersion(sonarVersion)) {
            update.setStatus(Status.COMPATIBLE);
        } else {
            for (Version requiredSonarVersion : pluginRelease.getRequiredSonarVersions()) {
                if (requiredSonarVersion.compareTo(sonarVersion) <= 0) continue;
                update.setStatus(Status.REQUIRE_SONAR_UPGRADE);
                break;
            }
        }
        return update;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isCompatible() {
        return Status.COMPATIBLE.equals((Object)this.status);
    }

    public boolean isIncompatible() {
        return Status.INCOMPATIBLE.equals((Object)this.status);
    }

    public boolean requiresSonarUpgrade() {
        return Status.REQUIRE_SONAR_UPGRADE.equals((Object)this.status);
    }

    public boolean requiresSonarUpgradeForDependencies() {
        return Status.DEPENDENCIES_REQUIRE_SONAR_UPGRADE.equals((Object)this.status);
    }

    public Plugin getPlugin() {
        return (Plugin)this.release.getArtifact();
    }

    public Release getRelease() {
        return this.release;
    }

    public void setRelease(Release release) {
        this.release = release;
    }

    public List<Release> getDependencies() {
        return ImmutableList.copyOf(this.dependencies);
    }

    public void setDependencies(List<Release> dependencies) {
        dependencies.remove(this.release);
        this.dependencies = dependencies;
    }

    public static enum Status {
        COMPATIBLE,
        INCOMPATIBLE,
        REQUIRE_SONAR_UPGRADE,
        DEPENDENCIES_REQUIRE_SONAR_UPGRADE;

    }
}

