/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.Credentials;
import org.sonar.server.authentication.CredentialsExternalAuthentication;
import org.sonar.server.authentication.CredentialsLocalAuthentication;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;

public class CredentialsAuthentication {
    private final DbClient dbClient;
    private final AuthenticationEvent authenticationEvent;
    private final CredentialsExternalAuthentication externalAuthentication;
    private final CredentialsLocalAuthentication localAuthentication;

    public CredentialsAuthentication(DbClient dbClient, AuthenticationEvent authenticationEvent, CredentialsExternalAuthentication externalAuthentication, CredentialsLocalAuthentication localAuthentication) {
        this.dbClient = dbClient;
        this.authenticationEvent = authenticationEvent;
        this.externalAuthentication = externalAuthentication;
        this.localAuthentication = localAuthentication;
    }

    public UserDto authenticate(Credentials credentials, HttpServletRequest request, AuthenticationEvent.Method method) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.authenticate(dbSession, credentials, request, method);
            return userDto;
        }
    }

    private UserDto authenticate(DbSession dbSession, Credentials credentials, HttpServletRequest request, AuthenticationEvent.Method method) {
        UserDto localUser = this.dbClient.userDao().selectActiveUserByLogin(dbSession, credentials.getLogin());
        if (localUser != null && localUser.isLocal()) {
            this.localAuthentication.authenticate(dbSession, localUser, credentials.getPassword().orElse(null), method);
            dbSession.commit();
            this.authenticationEvent.loginSuccess(request, localUser.getLogin(), AuthenticationEvent.Source.local(method));
            return localUser;
        }
        Optional<UserDto> externalUser = this.externalAuthentication.authenticate(credentials, request, method);
        if (externalUser.isPresent()) {
            return externalUser.get();
        }
        throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.local(method)).setLogin(credentials.getLogin()).setMessage(localUser != null && !localUser.isLocal() ? "User is not local" : "No active user for login").build();
    }
}

