/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.math.BigInteger;
import java.security.SecureRandom;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.server.authentication.Cookies;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;

public class OAuthCsrfVerifier {
    private static final String CSRF_STATE_COOKIE = "OAUTHSTATE";
    private static final String DEFAULT_STATE_PARAMETER_NAME = "state";

    public String generateState(HttpServletRequest request, HttpServletResponse response) {
        String state = new BigInteger(130, new SecureRandom()).toString(32);
        response.addCookie(Cookies.newCookieBuilder(request).setName(CSRF_STATE_COOKIE).setValue(DigestUtils.sha256Hex((String)state)).setHttpOnly(true).setExpiry(-1).build());
        return state;
    }

    public void verifyState(HttpServletRequest request, HttpServletResponse response, OAuth2IdentityProvider provider) {
        this.verifyState(request, response, provider, DEFAULT_STATE_PARAMETER_NAME);
    }

    public void verifyState(HttpServletRequest request, HttpServletResponse response, OAuth2IdentityProvider provider, String parameterName) {
        Cookie cookie = Cookies.findCookie(CSRF_STATE_COOKIE, request).orElseThrow(AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.oauth2(provider)).setMessage(String.format("Cookie '%s' is missing", CSRF_STATE_COOKIE))::build);
        String hashInCookie = cookie.getValue();
        response.addCookie(Cookies.newCookieBuilder(request).setName(CSRF_STATE_COOKIE).setValue(null).setHttpOnly(true).setExpiry(0).build());
        String stateInRequest = request.getParameter(parameterName);
        if (StringUtils.isBlank((String)stateInRequest) || !DigestUtils.sha256Hex((String)stateInRequest).equals(hashInCookie)) {
            throw AuthenticationException.newBuilder().setSource(AuthenticationEvent.Source.oauth2(provider)).setMessage("CSRF state value is invalid").build();
        }
    }
}

