/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.BasicAuthentication;
import org.sonar.server.authentication.CustomAuthentication;
import org.sonar.server.authentication.HttpHeadersAuthentication;
import org.sonar.server.authentication.JwtHttpHandler;
import org.sonar.server.authentication.RequestAuthenticator;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.UserSessionFactory;

public class RequestAuthenticatorImpl
implements RequestAuthenticator {
    private final JwtHttpHandler jwtHttpHandler;
    private final BasicAuthentication basicAuthentication;
    private final HttpHeadersAuthentication httpHeadersAuthentication;
    private final UserSessionFactory userSessionFactory;
    private final List<CustomAuthentication> customAuthentications;

    public RequestAuthenticatorImpl(JwtHttpHandler jwtHttpHandler, BasicAuthentication basicAuthentication, HttpHeadersAuthentication httpHeadersAuthentication, UserSessionFactory userSessionFactory, CustomAuthentication[] customAuthentications) {
        this.jwtHttpHandler = jwtHttpHandler;
        this.basicAuthentication = basicAuthentication;
        this.httpHeadersAuthentication = httpHeadersAuthentication;
        this.userSessionFactory = userSessionFactory;
        this.customAuthentications = Arrays.asList(customAuthentications);
    }

    public RequestAuthenticatorImpl(JwtHttpHandler jwtHttpHandler, BasicAuthentication basicAuthentication, HttpHeadersAuthentication httpHeadersAuthentication, UserSessionFactory userSessionFactory) {
        this(jwtHttpHandler, basicAuthentication, httpHeadersAuthentication, userSessionFactory, new CustomAuthentication[0]);
    }

    @Override
    public UserSession authenticate(HttpServletRequest request, HttpServletResponse response) {
        for (CustomAuthentication customAuthentication : this.customAuthentications) {
            Optional<UserSession> session = customAuthentication.authenticate(request, response);
            if (!session.isPresent()) continue;
            return session.get();
        }
        Optional<UserDto> userOpt = this.loadUser(request, response);
        if (userOpt.isPresent()) {
            return this.userSessionFactory.create(userOpt.get());
        }
        return this.userSessionFactory.createAnonymous();
    }

    private Optional<UserDto> loadUser(HttpServletRequest request, HttpServletResponse response) {
        Optional<UserDto> user = this.httpHeadersAuthentication.authenticate(request, response);
        if (user.isPresent()) {
            return user;
        }
        user = this.jwtHttpHandler.validateToken(request, response);
        if (user.isPresent()) {
            return user;
        }
        return this.basicAuthentication.authenticate(request);
    }
}

