/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.property.PropertyQuery;
import org.sonar.server.user.UserSession;

public class ComponentViewerJsonWriter {
    private static final List<String> METRIC_KEYS = Collections.unmodifiableList(Arrays.asList("lines", "violations", "coverage", "duplicated_lines_density", "tests"));
    private final DbClient dbClient;

    public ComponentViewerJsonWriter(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void writeComponentWithoutFav(JsonWriter json, ComponentDto component, DbSession session, boolean includeSubProject) {
        String pullRequest;
        json.prop("key", component.getKey());
        json.prop("uuid", component.uuid());
        json.prop("path", component.path());
        json.prop("name", component.name());
        json.prop("longName", component.longName());
        json.prop("q", component.qualifier());
        ComponentDto project = this.dbClient.componentDao().selectOrFailByUuid(session, component.projectUuid());
        if (includeSubProject) {
            ComponentDto parentModule = this.retrieveParentModuleIfNotCurrentComponent(component, session);
            boolean displayParentModule = parentModule != null && !parentModule.uuid().equals(project.uuid());
            json.prop("subProject", displayParentModule ? parentModule.getKey() : null);
            json.prop("subProjectName", displayParentModule ? parentModule.longName() : null);
        }
        json.prop("project", project.getKey());
        json.prop("projectName", project.longName());
        String branch = project.getBranch();
        if (branch != null) {
            json.prop("branch", branch);
        }
        if ((pullRequest = project.getPullRequest()) != null) {
            json.prop("pullRequest", pullRequest);
        }
    }

    public void writeComponent(JsonWriter json, ComponentDto component, UserSession userSession, DbSession session) {
        this.writeComponentWithoutFav(json, component, session, true);
        List propertyDtos = this.dbClient.propertiesDao().selectByQuery(PropertyQuery.builder().setKey("favourite").setComponentId(component.getId()).setUserId(userSession.getUserId()).build(), session);
        boolean isFavourite = propertyDtos.size() == 1;
        json.prop("fav", isFavourite);
    }

    public void writeMeasures(JsonWriter json, ComponentDto component, DbSession session) {
        Map<String, LiveMeasureDto> measuresByMetricKey = this.loadMeasuresGroupedByMetricKey(component, session);
        json.name("measures").beginObject();
        json.prop("lines", ComponentViewerJsonWriter.formatMeasure(measuresByMetricKey, CoreMetrics.LINES));
        json.prop("coverage", ComponentViewerJsonWriter.formatMeasure(measuresByMetricKey, CoreMetrics.COVERAGE));
        json.prop("duplicationDensity", ComponentViewerJsonWriter.formatMeasure(measuresByMetricKey, CoreMetrics.DUPLICATED_LINES_DENSITY));
        json.prop("issues", ComponentViewerJsonWriter.formatMeasure(measuresByMetricKey, CoreMetrics.VIOLATIONS));
        json.prop("tests", ComponentViewerJsonWriter.formatMeasure(measuresByMetricKey, CoreMetrics.TESTS));
        json.endObject();
    }

    private Map<String, LiveMeasureDto> loadMeasuresGroupedByMetricKey(ComponentDto component, DbSession dbSession) {
        List metrics = this.dbClient.metricDao().selectByKeys(dbSession, METRIC_KEYS);
        ImmutableMap metricsById = Maps.uniqueIndex((Iterable)metrics, MetricDto::getId);
        List measures = this.dbClient.liveMeasureDao().selectByComponentUuidsAndMetricIds(dbSession, Collections.singletonList(component.uuid()), metricsById.keySet());
        return Maps.uniqueIndex((Iterable)measures, arg_0 -> ComponentViewerJsonWriter.lambda$loadMeasuresGroupedByMetricKey$0((Map)metricsById, arg_0));
    }

    @CheckForNull
    private static String formatMeasure(Map<String, LiveMeasureDto> measuresByMetricKey, Metric metric) {
        LiveMeasureDto measure = measuresByMetricKey.get(metric.getKey());
        return ComponentViewerJsonWriter.formatMeasure(measure, metric);
    }

    private static String formatMeasure(@Nullable LiveMeasureDto measure, Metric metric) {
        if (measure == null) {
            return null;
        }
        Double value = ComponentViewerJsonWriter.getDoubleValue(measure, metric);
        if (value != null) {
            return Double.toString(value);
        }
        return null;
    }

    @CheckForNull
    private static Double getDoubleValue(LiveMeasureDto measure, Metric metric) {
        Double value = measure.getValue();
        if (BooleanUtils.isTrue((Boolean)metric.isOptimizedBestValue()) && value == null) {
            value = metric.getBestValue();
        }
        return value;
    }

    @CheckForNull
    private ComponentDto retrieveParentModuleIfNotCurrentComponent(ComponentDto componentDto, DbSession session) {
        String moduleUuid = componentDto.moduleUuid();
        if (moduleUuid == null || componentDto.uuid().equals(moduleUuid)) {
            return null;
        }
        return this.dbClient.componentDao().selectOrFailByUuid(session, moduleUuid);
    }

    private static /* synthetic */ String lambda$loadMeasuresGroupedByMetricKey$0(Map metricsById, LiveMeasureDto m) {
        return ((MetricDto)metricsById.get(m.getMetricId())).getKey();
    }
}

