/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.duplication.ws;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.component.ComponentDto;

public class Duplication {
    private final ComponentDto componentDto;
    private final String componentDbKey;
    private final Integer from;
    private final Integer size;
    private final boolean removed;

    private Duplication(@Nullable ComponentDto componentDto, String componentDbKey, Integer from, Integer size, boolean removed) {
        this.componentDto = componentDto;
        this.componentDbKey = componentDbKey;
        this.from = from;
        this.size = size;
        this.removed = removed;
    }

    static Duplication newRemovedComponent(String componentDbKey, Integer from, Integer size) {
        return new Duplication(null, componentDbKey, from, size, true);
    }

    static Duplication newTextComponent(String componentDbKey, Integer from, Integer size) {
        return new Duplication(null, componentDbKey, from, size, false);
    }

    static Duplication newComponent(ComponentDto componentDto, Integer from, Integer size) {
        return new Duplication(componentDto, componentDto.getDbKey(), from, size, false);
    }

    String componentDbKey() {
        return this.componentDbKey;
    }

    Integer from() {
        return this.from;
    }

    Integer size() {
        return this.size;
    }

    public boolean removed() {
        return this.removed;
    }

    @CheckForNull
    public ComponentDto componentDto() {
        return this.componentDto;
    }
}

