/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.duplication.ws;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDao;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.duplication.ws.Duplication;
import org.sonar.server.duplication.ws.DuplicationsParser;
import org.sonarqube.ws.Duplications;

public class ShowResponseBuilder {
    private final ComponentDao componentDao;

    public ShowResponseBuilder(DbClient dbClient) {
        this.componentDao = dbClient.componentDao();
    }

    @VisibleForTesting
    ShowResponseBuilder(ComponentDao componentDao) {
        this.componentDao = componentDao;
    }

    Duplications.ShowResponse build(DbSession session, List<DuplicationsParser.Block> blocks, @Nullable String branch, @Nullable String pullRequest) {
        LinkedHashMap<String, Reference> refByComponentKey = new LinkedHashMap<String, Reference>();
        Duplications.ShowResponse.Builder response = Duplications.ShowResponse.newBuilder();
        blocks.stream().map(block -> ShowResponseBuilder.toWsDuplication(block, refByComponentKey)).forEach(arg_0 -> ((Duplications.ShowResponse.Builder)response).addDuplications(arg_0));
        this.writeFileRefs(session, refByComponentKey, response, branch, pullRequest);
        return response.build();
    }

    private static Duplications.Duplication.Builder toWsDuplication(DuplicationsParser.Block block, Map<String, Reference> refByComponentKey) {
        Duplications.Duplication.Builder wsDuplication = Duplications.Duplication.newBuilder();
        block.getDuplications().stream().map(duplication -> ShowResponseBuilder.toWsBlock(duplication, refByComponentKey)).forEach(arg_0 -> ((Duplications.Duplication.Builder)wsDuplication).addBlocks(arg_0));
        return wsDuplication;
    }

    private static Duplications.Block.Builder toWsBlock(Duplication duplication, Map<String, Reference> refByComponentKey) {
        Duplications.Block.Builder block = Duplications.Block.newBuilder();
        if (!duplication.removed()) {
            Reference ref = refByComponentKey.computeIfAbsent(duplication.componentDbKey(), k -> new Reference(Integer.toString(refByComponentKey.size() + 1), duplication.componentDto(), duplication.componentDbKey()));
            block.setRef(ref.getId());
        }
        block.setFrom(duplication.from().intValue());
        block.setSize(duplication.size().intValue());
        return block;
    }

    private void writeFileRefs(DbSession session, Map<String, Reference> refByComponentKey, Duplications.ShowResponse.Builder response, @Nullable String branch, @Nullable String pullRequest) {
        HashMap<String, ComponentDto> projectsByUuid = new HashMap<String, ComponentDto>();
        HashMap<String, ComponentDto> parentModulesByUuid = new HashMap<String, ComponentDto>();
        for (Map.Entry<String, Reference> entry : refByComponentKey.entrySet()) {
            Reference ref = entry.getValue();
            ComponentDto file = ref.getDto();
            if (file != null) {
                ComponentDto project = this.getProject(file.projectUuid(), projectsByUuid, session);
                ComponentDto parentModule = this.getParentProject(file.moduleUuid(), parentModulesByUuid, session);
                response.putFiles(ref.getId(), ShowResponseBuilder.toWsFile(file, project, parentModule, branch, pullRequest));
                continue;
            }
            response.putFiles(ref.getId(), ShowResponseBuilder.toWsFile(ref.getComponentKey(), branch, pullRequest));
        }
    }

    private static Duplications.File toWsFile(String componentKey, @Nullable String branch, @Nullable String pullRequest) {
        Duplications.File.Builder wsFile = Duplications.File.newBuilder();
        String keyWithoutBranch = ComponentDto.removeBranchAndPullRequestFromKey((String)componentKey);
        wsFile.setKey(keyWithoutBranch);
        wsFile.setName(StringUtils.substringAfterLast((String)keyWithoutBranch, (String)":"));
        Optional.ofNullable(branch).ifPresent(arg_0 -> ((Duplications.File.Builder)wsFile).setBranch(arg_0));
        Optional.ofNullable(pullRequest).ifPresent(arg_0 -> ((Duplications.File.Builder)wsFile).setPullRequest(arg_0));
        return wsFile.build();
    }

    private static Duplications.File toWsFile(ComponentDto file, @Nullable ComponentDto project, @Nullable ComponentDto subProject, @Nullable String branch, @Nullable String pullRequest) {
        Duplications.File.Builder wsFile = Duplications.File.newBuilder();
        wsFile.setKey(file.getKey());
        wsFile.setUuid(file.uuid());
        wsFile.setName(file.longName());
        Optional.ofNullable(project).ifPresent(p -> {
            boolean displaySubProject;
            wsFile.setProject(p.getKey());
            wsFile.setProjectUuid(p.uuid());
            wsFile.setProjectName(p.longName());
            boolean bl = displaySubProject = subProject != null && !subProject.uuid().equals(project.uuid());
            if (displaySubProject) {
                wsFile.setSubProject(subProject.getKey());
                wsFile.setSubProjectUuid(subProject.uuid());
                wsFile.setSubProjectName(subProject.longName());
            }
            Optional.ofNullable(branch).ifPresent(arg_0 -> ((Duplications.File.Builder)wsFile).setBranch(arg_0));
            Optional.ofNullable(pullRequest).ifPresent(arg_0 -> ((Duplications.File.Builder)wsFile).setPullRequest(arg_0));
        });
        return wsFile.build();
    }

    private ComponentDto getProject(String projectUuid, Map<String, ComponentDto> projectsByUuid, DbSession session) {
        Optional projectOptional;
        ComponentDto project = projectsByUuid.get(projectUuid);
        if (project == null && (projectOptional = this.componentDao.selectByUuid(session, projectUuid)).isPresent()) {
            project = (ComponentDto)projectOptional.get();
            projectsByUuid.put(project.uuid(), project);
        }
        return project;
    }

    private ComponentDto getParentProject(String rootUuid, Map<String, ComponentDto> subProjectsByUuid, DbSession session) {
        Optional projectOptional;
        ComponentDto project = subProjectsByUuid.get(rootUuid);
        if (project == null && (projectOptional = this.componentDao.selectByUuid(session, rootUuid)).isPresent()) {
            project = (ComponentDto)projectOptional.get();
            subProjectsByUuid.put(project.uuid(), project);
        }
        return project;
    }

    private static class Reference {
        private final String id;
        private final ComponentDto dto;
        private final String componentKey;

        public Reference(String id, @Nullable ComponentDto dto, String componentKey) {
            this.id = id;
            this.dto = dto;
            this.componentKey = componentKey;
        }

        public String getId() {
            return this.id;
        }

        @CheckForNull
        public ComponentDto getDto() {
            return this.dto;
        }

        public String getComponentKey() {
            return this.componentKey;
        }
    }
}

