/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.ProcessProperties;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexDefinitionHash;
import org.sonar.server.es.IndexDefinitions;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.metadata.EsDbCompatibility;
import org.sonar.server.es.metadata.MetadataIndex;
import org.sonar.server.es.metadata.MetadataIndexDefinition;
import org.sonar.server.es.newindex.BuiltIndex;
import org.sonar.server.es.newindex.NewIndex;
import org.sonar.server.platform.db.migration.es.MigrationEsClient;

@ServerSide
public class IndexCreator
implements Startable {
    private static final Logger LOGGER = Loggers.get(IndexCreator.class);
    private final MetadataIndexDefinition metadataIndexDefinition;
    private final MetadataIndex metadataIndex;
    private final EsClient client;
    private final MigrationEsClient migrationEsClient;
    private final IndexDefinitions definitions;
    private final EsDbCompatibility esDbCompatibility;
    private final Configuration configuration;

    public IndexCreator(EsClient client, IndexDefinitions definitions, MetadataIndexDefinition metadataIndexDefinition, MetadataIndex metadataIndex, MigrationEsClient migrationEsClient, EsDbCompatibility esDbCompatibility, Configuration configuration) {
        this.client = client;
        this.definitions = definitions;
        this.metadataIndexDefinition = metadataIndexDefinition;
        this.metadataIndex = metadataIndex;
        this.migrationEsClient = migrationEsClient;
        this.esDbCompatibility = esDbCompatibility;
        this.configuration = configuration;
    }

    public void start() {
        IndexType.IndexMainType metadataMainType = MetadataIndexDefinition.TYPE_METADATA;
        if (!((IndicesExistsResponse)this.client.prepareIndicesExist(metadataMainType.getIndex()).get()).isExists()) {
            IndexDefinition.IndexDefinitionContext context = new IndexDefinition.IndexDefinitionContext();
            this.metadataIndexDefinition.define(context);
            NewIndex index2 = (NewIndex)context.getIndices().values().iterator().next();
            this.createIndex(index2.build(), false);
        } else {
            this.ensureWritable(metadataMainType);
        }
        this.checkDbCompatibility(this.definitions.getIndices().values());
        this.definitions.getIndices().values().stream().filter(i -> !i.getMainType().equals((Object)metadataMainType)).forEach(index -> {
            boolean exists = ((IndicesExistsResponse)this.client.prepareIndicesExist(index.getMainType().getIndex()).get()).isExists();
            if (!exists) {
                this.createIndex((BuiltIndex<?>)index, true);
            } else if (this.hasDefinitionChange((BuiltIndex<?>)index)) {
                this.updateIndex((BuiltIndex<?>)index);
            } else {
                this.ensureWritable(index.getMainType());
            }
        });
    }

    private void ensureWritable(IndexType.IndexMainType mainType) {
        if (this.isReadOnly(mainType)) {
            this.removeReadOnly(mainType);
        }
    }

    private boolean isReadOnly(IndexType.IndexMainType mainType) {
        String indexName = mainType.getIndex().getName();
        String readOnly = ((GetSettingsResponse)this.client.nativeClient().admin().indices().getSettings(new GetSettingsRequest().indices(new String[]{indexName})).actionGet()).getSetting(indexName, "index.blocks.read_only_allow_delete");
        return readOnly != null && "true".equalsIgnoreCase(readOnly);
    }

    private void removeReadOnly(IndexType.IndexMainType mainType) {
        LOGGER.info("Index [{}] is read-only. Making it writable...", (Object)mainType.getIndex().getName());
        String indexName = mainType.getIndex().getName();
        Settings.Builder builder = Settings.builder();
        builder.putNull("index.blocks.read_only_allow_delete");
        this.client.nativeClient().admin().indices().updateSettings(new UpdateSettingsRequest().indices(new String[]{indexName}).settings(builder.build())).actionGet();
    }

    public void stop() {
    }

    private void createIndex(BuiltIndex<?> builtIndex, boolean useMetadata) {
        CreateIndexResponse indexResponse;
        Index index = builtIndex.getMainType().getIndex();
        LOGGER.info(String.format("Create index [%s]", index.getName()));
        Settings.Builder settings = Settings.builder();
        settings.put(builtIndex.getSettings());
        if (useMetadata) {
            this.metadataIndex.setHash(index, IndexDefinitionHash.of(builtIndex));
            this.metadataIndex.setInitialized((IndexType)builtIndex.getMainType(), false);
            builtIndex.getRelationTypes().forEach(relationType -> this.metadataIndex.setInitialized((IndexType)relationType, false));
        }
        if (!(indexResponse = (CreateIndexResponse)this.client.prepareCreate(index).setSettings(settings).get()).isAcknowledged()) {
            throw new IllegalStateException("Failed to create index [" + index.getName() + "]");
        }
        this.client.waitForStatus(ClusterHealthStatus.YELLOW);
        LOGGER.info("Create type {}", (Object)builtIndex.getMainType().format());
        AcknowledgedResponse mappingResponse = (AcknowledgedResponse)this.client.preparePutMapping(index).setType(builtIndex.getMainType().getType()).setSource(builtIndex.getAttributes()).get();
        if (!mappingResponse.isAcknowledged()) {
            throw new IllegalStateException("Failed to create type " + builtIndex.getMainType().getType());
        }
        this.client.waitForStatus(ClusterHealthStatus.YELLOW);
    }

    private void deleteIndex(String indexName) {
        this.client.nativeClient().admin().indices().prepareDelete(new String[]{indexName}).get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateIndex(BuiltIndex<?> index) {
        boolean blueGreen = this.configuration.getBoolean(ProcessProperties.Property.BLUE_GREEN_ENABLED.getKey()).orElse(false);
        String indexName = index.getMainType().getIndex().getName();
        if (blueGreen) {
            if (!this.migrationEsClient.getUpdatedIndices().contains(indexName)) throw new IllegalStateException("Blue/green deployment is not supported. Elasticsearch index [" + indexName + "] changed and needs to be dropped.");
            LOGGER.info("Resetting definition hash of Elasticsearch index [{}]", (Object)indexName);
            this.metadataIndex.setHash(index.getMainType().getIndex(), IndexDefinitionHash.of(index));
            return;
        } else {
            LOGGER.info("Delete Elasticsearch index {} (structure changed)", (Object)indexName);
            this.deleteIndex(indexName);
            this.createIndex(index, true);
        }
    }

    private boolean hasDefinitionChange(BuiltIndex<?> index) {
        return this.metadataIndex.getHash(index.getMainType().getIndex()).map(hash -> {
            String defHash = IndexDefinitionHash.of((BuiltIndex)index);
            return !StringUtils.equals((String)hash, (String)defHash);
        }).orElse(true);
    }

    private void checkDbCompatibility(Collection<BuiltIndex> definitions) {
        List<String> existingIndices = this.loadExistingIndicesExceptMetadata(definitions);
        if (!existingIndices.isEmpty()) {
            boolean delete = false;
            if (!this.esDbCompatibility.hasSameDbVendor()) {
                LOGGER.info("Delete Elasticsearch indices (DB vendor changed)");
                delete = true;
            }
            if (delete) {
                existingIndices.forEach(this::deleteIndex);
            }
        }
        this.esDbCompatibility.markAsCompatible();
    }

    private List<String> loadExistingIndicesExceptMetadata(Collection<BuiltIndex> definitions) {
        Set definedNames = definitions.stream().map(t -> t.getMainType().getIndex().getName()).collect(Collectors.toSet());
        return Arrays.stream(((GetIndexResponse)this.client.nativeClient().admin().indices().prepareGetIndex().get()).getIndices()).filter(definedNames::contains).filter(index -> !MetadataIndexDefinition.DESCRIPTOR.getName().equals(index)).collect(Collectors.toList());
    }
}

