/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.es.EsClient;
import org.sonar.server.platform.db.migration.es.MigrationEsClient;

public class MigrationEsClientImpl
implements MigrationEsClient {
    private final EsClient client;
    private final Set<String> updatedIndices = new HashSet<String>();

    public MigrationEsClientImpl(EsClient client) {
        this.client = client;
    }

    public void deleteIndexes(String name, String ... otherNames) {
        Map indices = ((IndicesStatsResponse)this.client.nativeClient().admin().indices().prepareStats(new String[0]).get()).getIndices();
        Set existingIndices = (Set)indices.values().stream().map(IndexStats::getIndex).collect(MoreCollectors.toSet());
        Stream.concat(Stream.of(name), Arrays.stream(otherNames)).distinct().filter(existingIndices::contains).forEach(this::deleteIndex);
    }

    public void addMappingToExistingIndex(String index, String type, String mappingName, String mappingType, Map<String, String> options) {
        IndexStats stats = ((IndicesStatsResponse)this.client.nativeClient().admin().indices().prepareStats(new String[0]).get()).getIndex(index);
        if (stats != null) {
            Loggers.get(this.getClass()).info("Add mapping [{}] to Elasticsearch index [{}]", (Object)mappingName, (Object)index);
            String mappingOptions = Stream.concat(Stream.of(Maps.immutableEntry((Object)"type", (Object)mappingType)), options.entrySet().stream()).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
            this.client.nativeClient().admin().indices().preparePutMapping(new String[]{index}).setType(type).setSource(new Object[]{mappingName, mappingOptions}).get();
            this.updatedIndices.add(index);
        }
    }

    public Set<String> getUpdatedIndices() {
        return this.updatedIndices;
    }

    private void deleteIndex(String index) {
        Loggers.get(this.getClass()).info("Drop Elasticsearch index [{}]", (Object)index);
        this.client.nativeClient().admin().indices().prepareDelete(new String[]{index}).get();
    }
}

