/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.favorite.ws;

import java.util.function.Consumer;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.favorite.FavoriteUpdater;
import org.sonar.server.favorite.ws.FavoritesWsAction;
import org.sonar.server.user.UserSession;

public class RemoveAction
implements FavoritesWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final FavoriteUpdater favoriteUpdater;
    private final ComponentFinder componentFinder;

    public RemoveAction(UserSession userSession, DbClient dbClient, FavoriteUpdater favoriteUpdater, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.favoriteUpdater = favoriteUpdater;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove").setDescription("Remove a component (project, directory, file etc.) as favorite for the authenticated user.<br>Requires authentication.").setSince("6.3").setChangelog(new Change[]{new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", "component"))}).setPost(true).setHandler((RequestHandler)this);
        action.createParam("component").setDescription("Component key").setRequired(true).setExampleValue((Object)"my_project");
    }

    public void handle(Request request, Response response) throws Exception {
        this.removeFavorite().accept(request);
        response.noContent();
    }

    private Consumer<Request> removeFavorite() {
        return request -> {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                ComponentDto component = this.componentFinder.getByKey(dbSession, request.mandatoryParam("component"));
                this.userSession.checkLoggedIn();
                this.favoriteUpdater.remove(dbSession, component, this.userSession.isLoggedIn() ? this.userSession.getUserId() : null);
                dbSession.commit();
            }
        };
    }
}

