/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sonar.api.issue.Issue;
import org.sonar.api.server.ServerSide;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.issue.workflow.Condition;
import org.sonar.server.user.UserSession;

@ServerSide
public abstract class Action {
    private final String key;
    private final List<Condition> conditions;

    public Action(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Action key must be set");
        this.key = key;
        this.conditions = Lists.newArrayList();
    }

    public String key() {
        return this.key;
    }

    public Action setConditions(Condition ... conditions) {
        this.conditions.addAll((Collection<Condition>)ImmutableList.copyOf((Object[])conditions));
        return this;
    }

    public List<Condition> conditions() {
        return this.conditions;
    }

    public boolean supports(DefaultIssue issue) {
        for (Condition condition : this.conditions) {
            if (condition.matches((Issue)issue)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean verify(Map<String, Object> var1, Collection<DefaultIssue> var2, UserSession var3);

    public abstract boolean execute(Map<String, Object> var1, Context var2);

    public abstract boolean shouldRefreshMeasures();

    public static interface Context {
        public DefaultIssue issue();

        public IssueChangeContext issueChangeContext();

        public ComponentDto project();
    }
}

