/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.IssueChangePostProcessor;
import org.sonar.server.issue.WebIssueStorage;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;
import org.sonar.server.issue.notification.IssuesChangesNotificationSerializer;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.notification.NotificationManager;

public class IssueUpdater {
    private final DbClient dbClient;
    private final WebIssueStorage issueStorage;
    private final NotificationManager notificationService;
    private final IssueChangePostProcessor issueChangePostProcessor;
    private final IssuesChangesNotificationSerializer notificationSerializer;

    public IssueUpdater(DbClient dbClient, WebIssueStorage issueStorage, NotificationManager notificationService, IssueChangePostProcessor issueChangePostProcessor, IssuesChangesNotificationSerializer notificationSerializer) {
        this.dbClient = dbClient;
        this.issueStorage = issueStorage;
        this.notificationService = notificationService;
        this.issueChangePostProcessor = issueChangePostProcessor;
        this.notificationSerializer = notificationSerializer;
    }

    public SearchResponseData saveIssueAndPreloadSearchResponseData(DbSession dbSession, DefaultIssue issue, IssueChangeContext context, boolean refreshMeasures) {
        Optional<RuleDefinitionDto> rule = this.getRuleByKey(dbSession, issue.getRuleKey());
        ComponentDto project = this.dbClient.componentDao().selectOrFailByUuid(dbSession, issue.projectUuid());
        BranchDto branch = this.getBranch(dbSession, issue, issue.projectUuid());
        ComponentDto component = this.getComponent(dbSession, issue, issue.componentUuid());
        IssueDto issueDto = this.doSaveIssue(dbSession, issue, context, rule, project, branch);
        SearchResponseData result = new SearchResponseData(issueDto);
        rule.ifPresent(r -> result.addRules(Collections.singletonList(r)));
        result.addComponents(Collections.singleton(project));
        result.addComponents(Collections.singleton(component));
        if (refreshMeasures) {
            List changedIssues = (List)result.getIssues().stream().map(IssueDto::toDefaultIssue).collect(MoreCollectors.toList((int)result.getIssues().size()));
            this.issueChangePostProcessor.process(dbSession, changedIssues, Collections.singleton(component));
        }
        return result;
    }

    private IssueDto doSaveIssue(DbSession session, DefaultIssue issue, IssueChangeContext context, Optional<RuleDefinitionDto> rule, ComponentDto project, BranchDto branchDto) {
        IssueDto issueDto = this.issueStorage.save(session, Collections.singletonList(issue)).iterator().next();
        if (issue.updateDate() == null || !rule.isPresent() || !IssueUpdater.hasNotificationSupport(branchDto)) {
            return issueDto;
        }
        Optional<UserDto> assignee = Optional.ofNullable(issue.assignee()).map(assigneeUuid -> this.dbClient.userDao().selectByUuid(session, assigneeUuid));
        UserDto author = Optional.ofNullable(context.userUuid()).map(authorUuid -> this.dbClient.userDao().selectByUuid(session, authorUuid)).orElseThrow(() -> new IllegalStateException("Can not find dto for change author " + context.userUuid()));
        IssuesChangesNotificationBuilder notificationBuilder = new IssuesChangesNotificationBuilder(Collections.singleton(new IssuesChangesNotificationBuilder.ChangedIssue.Builder(issue.key()).setNewResolution(issue.resolution()).setNewStatus(issue.status()).setAssignee((IssuesChangesNotificationBuilder.User)assignee.map(assigneeDto -> new IssuesChangesNotificationBuilder.User(assigneeDto.getUuid(), assigneeDto.getLogin(), assigneeDto.getName())).orElse(null)).setRule(rule.map(r -> new IssuesChangesNotificationBuilder.Rule(r.getKey(), r.getName())).get()).setProject(new IssuesChangesNotificationBuilder.Project.Builder(project.uuid()).setKey(project.getKey()).setProjectName(project.name()).setBranchName(branchDto.isMain() ? null : branchDto.getKey()).build()).build()), (IssuesChangesNotificationBuilder.Change)new IssuesChangesNotificationBuilder.UserChange(issue.updateDate().getTime(), new IssuesChangesNotificationBuilder.User(author.getUuid(), author.getLogin(), author.getName())));
        this.notificationService.scheduleForSending((Notification)this.notificationSerializer.serialize(notificationBuilder));
        return issueDto;
    }

    private static boolean hasNotificationSupport(BranchDto branch) {
        return branch.getBranchType() != BranchType.PULL_REQUEST && branch.getBranchType() != BranchType.SHORT;
    }

    private ComponentDto getComponent(DbSession dbSession, DefaultIssue issue, @Nullable String componentUuid) {
        String issueKey = issue.key();
        Preconditions.checkState((componentUuid != null ? 1 : 0) != 0, (String)"Issue '%s' has no component", (Object[])new Object[]{issueKey});
        ComponentDto component = this.dbClient.componentDao().selectByUuid(dbSession, componentUuid).orElse(null);
        Preconditions.checkState((component != null ? 1 : 0) != 0, (String)"Component uuid '%s' for issue key '%s' cannot be found", (Object[])new Object[]{componentUuid, issueKey});
        return component;
    }

    private BranchDto getBranch(DbSession dbSession, DefaultIssue issue, @Nullable String projectUuid) {
        String issueKey = issue.key();
        Preconditions.checkState((projectUuid != null ? 1 : 0) != 0, (String)"Issue '%s' has no project", (Object[])new Object[]{issueKey});
        BranchDto component = this.dbClient.branchDao().selectByUuid(dbSession, projectUuid).orElse(null);
        Preconditions.checkState((component != null ? 1 : 0) != 0, (String)"Branch uuid '%s' for issue key '%s' cannot be found", (Object[])new Object[]{projectUuid, issueKey});
        return component;
    }

    private Optional<RuleDefinitionDto> getRuleByKey(DbSession session, RuleKey ruleKey) {
        Optional rule = this.dbClient.ruleDao().selectDefinitionByKey(session, ruleKey);
        return rule.isPresent() && ((RuleDefinitionDto)rule.get()).getStatus() != RuleStatus.REMOVED ? rule : Optional.empty();
    }
}

