/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.issue.Issue;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.UserDto;
import org.sonar.process.ProcessProperties;
import org.sonar.server.es.Facets;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.issue.SearchRequest;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.issue.index.IssueQuery;
import org.sonar.server.issue.index.IssueQueryFactory;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.SearchAdditionalField;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.issue.ws.SearchResponseFormat;
import org.sonar.server.issue.ws.SearchResponseLoader;
import org.sonar.server.security.SecurityStandardHelper;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Issues;

public class SearchAction
implements IssuesWsAction,
Startable {
    private static final String LOGIN_MYSELF = "__me__";
    static final List<String> SUPPORTED_FACETS = ImmutableList.of((Object)"projects", (Object)"moduleUuids", (Object)"fileUuids", (Object)"assigned_to_me", (Object)"severities", (Object)"statuses", (Object)"resolutions", (Object)"rules", (Object)"assignees", (Object)"authors", (Object)"author", (Object)"directories", (Object[])new String[]{"languages", "tags", "types", "owaspTop10", "sansTop25", "cwe", "createdAt", "sonarsourceSecurity"});
    private static final String INTERNAL_PARAMETER_DISCLAIMER = "This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. ";
    private static final Set<String> FACETS_REQUIRING_PROJECT_OR_ORGANIZATION = Sets.newHashSet((Object[])new String[]{"moduleUuids", "fileUuids", "directories"});
    private static final Joiner COMA_JOINER = Joiner.on((String)",");
    private final UserSession userSession;
    private final IssueIndex issueIndex;
    private final IssueQueryFactory issueQueryFactory;
    private final SearchResponseLoader searchResponseLoader;
    private final SearchResponseFormat searchResponseFormat;
    private final Configuration config;
    private final System2 system2;
    private final DbClient dbClient;
    private boolean isOnSonarCloud;

    public SearchAction(UserSession userSession, IssueIndex issueIndex, IssueQueryFactory issueQueryFactory, SearchResponseLoader searchResponseLoader, SearchResponseFormat searchResponseFormat, Configuration config, System2 system2, DbClient dbClient) {
        this.userSession = userSession;
        this.issueIndex = issueIndex;
        this.issueQueryFactory = issueQueryFactory;
        this.searchResponseLoader = searchResponseLoader;
        this.searchResponseFormat = searchResponseFormat;
        this.config = config;
        this.system2 = system2;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("search").setHandler((RequestHandler)this).setDescription("Search for issues.<br>At most one of the following parameters can be provided at the same time: %s and %s.<br>Requires the 'Browse' permission on the specified project(s).", new Object[]{"componentKeys", "componentUuids"}).setSince("3.6").setChangelog(new Change[]{new Change("7.8", String.format("added new Security Hotspots statuses : %s, %s and %s", "TO_REVIEW", "IN_REVIEW", "REVIEWED")), new Change("7.8", "Security hotspots are returned by default"), new Change("7.7", String.format("Value '%s' in parameter '%s' is deprecated, please use '%s' instead", "authors", "facets", "author")), new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", "componentKeys")), new Change("7.4", "The facet 'projectUuids' is dropped in favour of the new facet 'projects'. Note that they are not strictly identical, the latter returns the project keys."), new Change("7.4", String.format("Parameter '%s' does not accept anymore deprecated value 'debt'", "facetMode")), new Change("7.3", "response field 'fromHotspot' added to issues that are security hotspots"), new Change("7.3", "added facets 'sansTop25', 'owaspTop10' and 'cwe'"), new Change("7.2", "response field 'externalRuleEngine' added to issues that have been imported from an external rule engine"), new Change("7.2", String.format("value '%s' in parameter '%s' is deprecated, it won't have any effect", "ASSIGNEE", "s")), new Change("6.5", "parameters 'projects', 'projectUuids', 'moduleUuids', 'directories', 'fileUuids' are marked as internal"), new Change("6.3", "response field 'email' is renamed 'avatar'"), new Change("5.5", "response fields 'reporter' and 'actionPlan' are removed (drop of action plan and manual issue features)"), new Change("5.5", "parameters 'reporters', 'actionPlans' and 'planned' are dropped and therefore ignored (drop of action plan and manual issue features)"), new Change("5.5", "response field 'debt' is renamed 'effort'")}).setResponseExample(this.getClass().getResource("search-example.json"));
        action.addPagingParams(100, 500);
        action.createParam("facets").setDescription("Comma-separated list of the facets to be computed. No facet is computed by default.").setPossibleValues(SUPPORTED_FACETS);
        action.createParam("facetMode").setDefaultValue((Object)"count").setDeprecatedSince("7.9").setDescription("Choose the returned value for facet items, either count of issues or sum of remediation effort.").setPossibleValues((Object[])new String[]{"count", "effort"});
        action.addSortParams(IssueQuery.SORTS, null, true);
        action.createParam("additionalFields").setSince("5.2").setDescription("Comma-separated list of the optional fields to be returned in response. Action plans are dropped in 5.5, it is not returned in the response.").setPossibleValues(SearchAdditionalField.possibleValues());
        SearchAction.addComponentRelatedParams(action);
        action.createParam("issues").setDescription("Comma-separated list of issue keys").setExampleValue((Object)"5bccd6e8-f525-43a2-8d76-fcb13dde79ef");
        action.createParam("severities").setDescription("Comma-separated list of severities").setExampleValue((Object)"BLOCKER,CRITICAL").setPossibleValues((Collection)Severity.ALL);
        action.createParam("statuses").setDescription("Comma-separated list of statuses").setExampleValue((Object)"OPEN,REOPENED").setPossibleValues((Collection)Issue.STATUSES);
        action.createParam("resolutions").setDescription("Comma-separated list of resolutions").setExampleValue((Object)"FIXED,REMOVED").setPossibleValues((Collection)Issue.RESOLUTIONS);
        action.createParam("resolved").setDescription("To match resolved or unresolved issues").setBooleanPossibleValues();
        action.createParam("rules").setDescription("Comma-separated list of coding rule keys. Format is &lt;repository&gt;:&lt;rule&gt;").setExampleValue((Object)"squid:AvoidCycles");
        action.createParam("tags").setDescription("Comma-separated list of tags.").setExampleValue((Object)"security,convention");
        action.createParam("types").setDescription("Comma-separated list of types.").setSince("5.5").setPossibleValues((Object[])RuleType.values()).setExampleValue((Object)String.format("%s,%s", RuleType.CODE_SMELL, RuleType.BUG));
        action.createParam("owaspTop10").setDescription("Comma-separated list of OWASP Top 10 lowercase categories.").setSince("7.3").setPossibleValues((Object[])new String[]{"a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "a10"});
        action.createParam("sansTop25").setDescription("Comma-separated list of SANS Top 25 categories.").setSince("7.3").setPossibleValues((Object[])new String[]{"insecure-interaction", "risky-resource", "porous-defenses"});
        action.createParam("cwe").setDescription("Comma-separated list of CWE identifiers. Use 'unknown' to select issues not associated to any CWE.").setExampleValue((Object)"12,125,unknown");
        action.createParam("sonarsourceSecurity").setDescription("Comma-separated list of SonarSource security categories. Use 'others' to select issues not associated with any category").setSince("7.8").setPossibleValues((Collection)ImmutableList.builder().addAll(SecurityStandardHelper.SONARSOURCE_CWE_MAPPING.keySet()).add((Object)"others").build());
        action.createParam("authors").setDeprecatedSince("7.7").setDescription("This parameter is deprecated, please use '%s' instead", new Object[]{"author"}).setExampleValue((Object)"torvalds@linux-foundation.org");
        action.createParam("author").setDescription("SCM accounts. To set several values, the parameter must be called once for each value.").setExampleValue((Object)"author=torvalds@linux-foundation.org&author=linux@fondation.org");
        action.createParam("assignees").setDescription("Comma-separated list of assignee logins. The value '__me__' can be used as a placeholder for user who performs the request").setExampleValue((Object)"admin,usera,__me__");
        action.createParam("assigned").setDescription("To retrieve assigned or unassigned issues").setBooleanPossibleValues();
        action.createParam("languages").setDescription("Comma-separated list of languages. Available since 4.4").setExampleValue((Object)"java,js");
        action.createParam("createdAt").setDescription("Datetime to retrieve issues created during a specific analysis").setExampleValue((Object)"2017-10-19T13:00:00+0200");
        action.createParam("createdAfter").setDescription("To retrieve issues created after the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided. <br>If this parameter is set, createdSince must not be set").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("createdBefore").setDescription("To retrieve issues created before the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided.").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("createdInLast").setDescription("To retrieve issues created during a time span before the current time (exclusive). Accepted units are 'y' for year, 'm' for month, 'w' for week and 'd' for day. If this parameter is set, createdAfter must not be set").setExampleValue((Object)"1m2w (1 month 2 weeks)");
        action.createParam("sinceLeakPeriod").setDescription("To retrieve issues created since the leak period.<br>If this parameter is set to a truthy value, createdAfter must not be set and one component id or key must be provided.").setBooleanPossibleValues().setDefaultValue((Object)"false");
    }

    private static void addComponentRelatedParams(WebService.NewAction action) {
        action.createParam("onComponentOnly").setDescription("Return only issues at a component's level, not on its descendants (modules, directories, files, etc). This parameter is only considered when componentKeys or componentUuids is set.").setBooleanPossibleValues().setDefaultValue((Object)"false");
        action.createParam("componentKeys").setDescription("Comma-separated list of component keys. Retrieve issues associated to a specific list of components (and all its descendants). A component can be a portfolio, project, module, directory or file.").setExampleValue((Object)"my_project");
        action.createParam("componentUuids").setDescription("To retrieve issues associated to a specific list of components their sub-components (comma-separated list of component IDs). This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. A component can be a project, module, directory or file.").setDeprecatedSince("6.5").setExampleValue((Object)"584a89f2-8037-4f7b-b82c-8b45d2d63fb2");
        action.createParam("projects").setDescription("To retrieve issues associated to a specific list of projects (comma-separated list of project keys). This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. If this parameter is set, projectUuids must not be set.").setDeprecatedKey("projectKeys", "6.5").setInternal(true).setExampleValue((Object)"my_project");
        action.createParam("moduleUuids").setDescription("To retrieve issues associated to a specific list of modules (comma-separated list of module IDs). This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. ").setInternal(true).setDeprecatedSince("7.6").setExampleValue((Object)"7d8749e8-3070-4903-9188-bdd82933bb92");
        action.createParam("directories").setDescription("To retrieve issues associated to a specific list of directories (comma-separated list of directory paths). This parameter is only meaningful when a module is selected. This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. ").setInternal(true).setSince("5.1").setExampleValue((Object)"src/main/java/org/sonar/server/");
        action.createParam("fileUuids").setDescription("To retrieve issues associated to a specific list of files (comma-separated list of file IDs). This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. ").setInternal(true).setExampleValue((Object)"bdd82933-3070-4903-9188-7d8749e8bb92");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
        action.createParam("pullRequest").setDescription("Pull request id").setExampleValue((Object)"5461").setInternal(true).setSince("7.1");
        action.createParam("organization").setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.4");
    }

    public final void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SearchRequest searchRequest = this.toSearchWsRequest(dbSession, request);
            Issues.SearchWsResponse searchWsResponse = this.doHandle(dbSession, searchRequest);
            WsUtils.writeProtobuf((Message)searchWsResponse, request, response);
        }
    }

    private Issues.SearchWsResponse doHandle(DbSession dbSession, SearchRequest request) {
        SearchOptions options = this.createSearchOptionsFromRequest(dbSession, request);
        EnumSet<SearchAdditionalField> additionalFields = SearchAdditionalField.getFromRequest(request);
        IssueQuery query = this.issueQueryFactory.create(request);
        Set facetsRequiringProjectOrOrganizationParameter = (Set)options.getFacets().stream().filter(FACETS_REQUIRING_PROJECT_OR_ORGANIZATION::contains).collect(MoreCollectors.toSet());
        Preconditions.checkArgument((facetsRequiringProjectOrOrganizationParameter.isEmpty() || !query.projectUuids().isEmpty() || query.organizationUuid() != null ? 1 : 0) != 0, (String)"Facet(s) '%s' require to also filter by project or organization", (Object[])new Object[]{COMA_JOINER.join((Iterable)facetsRequiringProjectOrOrganizationParameter)});
        SearchResponse result = this.issueIndex.search(query, options);
        List issueKeys = (List)Arrays.stream(result.getHits().getHits()).map(SearchHit::getId).collect(MoreCollectors.toList((int)result.getHits().getHits().length));
        SearchResponseLoader.Collector collector = new SearchResponseLoader.Collector(issueKeys);
        this.collectLoggedInUser(collector);
        SearchAction.collectRequestParams(collector, request);
        Facets facets = new Facets(result, this.system2.getDefaultTimeZone());
        if (!options.getFacets().isEmpty()) {
            this.completeFacets(facets, request, query);
            SearchAction.collectFacets(collector, facets);
        }
        SearchResponseData preloadedData = new SearchResponseData(Collections.emptyList());
        preloadedData.addRules((List<RuleDefinitionDto>)ImmutableList.copyOf(query.rules()));
        SearchResponseData data = this.searchResponseLoader.load(preloadedData, collector, additionalFields, facets);
        Paging paging = Paging.forPageIndex((int)options.getPage()).withPageSize(options.getLimit()).andTotal((int)result.getHits().getTotalHits());
        return this.searchResponseFormat.formatSearch(additionalFields, data, paging, facets);
    }

    private SearchOptions createSearchOptionsFromRequest(DbSession dbSession, SearchRequest request) {
        SearchOptions options = new SearchOptions();
        options.setPage(request.getPage(), request.getPageSize());
        List facets = request.getFacets();
        if (facets == null || facets.isEmpty()) {
            return options;
        }
        ArrayList requestedFacets = new ArrayList(facets);
        if (this.isOnSonarCloud) {
            Optional organizationDto = Optional.empty();
            String organizationKey = request.getOrganization();
            if (organizationKey != null) {
                organizationDto = this.dbClient.organizationDao().selectByKey(dbSession, organizationKey);
            }
            if (!organizationDto.isPresent() || !this.userSession.hasMembership((OrganizationDto)organizationDto.get())) {
                requestedFacets.remove("author");
                requestedFacets.remove("authors");
            }
        }
        options.addFacets(requestedFacets);
        return options;
    }

    private void completeFacets(Facets facets, SearchRequest request, IssueQuery query) {
        SearchAction.addMandatoryValuesToFacet(facets, "severities", Severity.ALL);
        SearchAction.addMandatoryValuesToFacet(facets, "statuses", Issue.STATUSES);
        SearchAction.addMandatoryValuesToFacet(facets, "resolutions", Iterables.concat(Collections.singletonList(""), (Iterable)Issue.RESOLUTIONS));
        SearchAction.addMandatoryValuesToFacet(facets, "projects", query.projectUuids());
        SearchAction.addMandatoryValuesToFacet(facets, "moduleUuids", query.moduleUuids());
        SearchAction.addMandatoryValuesToFacet(facets, "fileUuids", query.fileUuids());
        SearchAction.addMandatoryValuesToFacet(facets, "componentUuids", request.getComponentUuids());
        ArrayList assignees = Lists.newArrayList((Object[])new String[]{""});
        List assigneesFromRequest = request.getAssigneeUuids();
        if (assigneesFromRequest != null) {
            assignees.addAll(assigneesFromRequest);
            assignees.remove(LOGIN_MYSELF);
        }
        SearchAction.addMandatoryValuesToFacet(facets, "assignees", assignees);
        SearchAction.addMandatoryValuesToFacet(facets, "assigned_to_me", Collections.singletonList(this.userSession.getUuid()));
        SearchAction.addMandatoryValuesToFacet(facets, "rules", query.rules().stream().map(r -> Integer.toString(r.getId())).collect(Collectors.toList()));
        SearchAction.addMandatoryValuesToFacet(facets, "languages", request.getLanguages());
        SearchAction.addMandatoryValuesToFacet(facets, "tags", request.getTags());
        SearchAction.addMandatoryValuesToFacet(facets, "types", RuleType.names());
        SearchAction.addMandatoryValuesToFacet(facets, "owaspTop10", request.getOwaspTop10());
        SearchAction.addMandatoryValuesToFacet(facets, "sansTop25", request.getSansTop25());
        SearchAction.addMandatoryValuesToFacet(facets, "cwe", request.getCwe());
        SearchAction.addMandatoryValuesToFacet(facets, "sonarsourceSecurity", request.getSonarsourceSecurity());
    }

    private static void addMandatoryValuesToFacet(Facets facets, String facetName, @Nullable Iterable<String> mandatoryValues) {
        LinkedHashMap buckets = facets.get(facetName);
        if (buckets != null && mandatoryValues != null) {
            for (String mandatoryValue : mandatoryValues) {
                if (buckets.containsKey(mandatoryValue)) continue;
                buckets.put(mandatoryValue, 0L);
            }
        }
    }

    private void collectLoggedInUser(SearchResponseLoader.Collector collector) {
        if (this.userSession.isLoggedIn()) {
            collector.addUserUuids(Collections.singletonList(this.userSession.getUuid()));
        }
    }

    private static void collectFacets(SearchResponseLoader.Collector collector, Facets facets) {
        collector.addProjectUuids(facets.getBucketKeys("projects"));
        collector.addComponentUuids(facets.getBucketKeys("moduleUuids"));
        collector.addComponentUuids(facets.getBucketKeys("fileUuids"));
        collector.addComponentUuids(facets.getBucketKeys("componentUuids"));
        collector.addRuleIds(facets.getBucketKeys("rules"));
        collector.addUserUuids(facets.getBucketKeys("assignees"));
    }

    private static void collectRequestParams(SearchResponseLoader.Collector collector, SearchRequest request) {
        collector.addComponentUuids(request.getFileUuids());
        collector.addComponentUuids(request.getModuleUuids());
        collector.addComponentUuids(request.getComponentRootUuids());
        collector.addUserUuids(request.getAssigneeUuids());
    }

    private SearchRequest toSearchWsRequest(DbSession dbSession, Request request) {
        return new SearchRequest().setAdditionalFields(request.paramAsStrings("additionalFields")).setAsc(request.mandatoryParamAsBoolean("asc")).setAssigned(request.paramAsBoolean("assigned")).setAssigneesUuid(this.getLogins(dbSession, request.paramAsStrings("assignees"))).setAuthors(request.hasParam("author") ? request.multiParam("author") : request.paramAsStrings("authors")).setComponentKeys(request.paramAsStrings("componentKeys")).setComponentUuids(request.paramAsStrings("componentUuids")).setCreatedAfter(request.param("createdAfter")).setCreatedAt(request.param("createdAt")).setCreatedBefore(request.param("createdBefore")).setCreatedInLast(request.param("createdInLast")).setDirectories(request.paramAsStrings("directories")).setFacetMode(request.mandatoryParam("facetMode")).setFacets(request.paramAsStrings("facets")).setFileUuids(request.paramAsStrings("fileUuids")).setIssues(request.paramAsStrings("issues")).setLanguages(request.paramAsStrings("languages")).setModuleUuids(request.paramAsStrings("moduleUuids")).setOnComponentOnly(request.paramAsBoolean("onComponentOnly")).setBranch(request.param("branch")).setPullRequest(request.param("pullRequest")).setOrganization(request.param("organization")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setProjectKeys(request.paramAsStrings("projects")).setProjects(request.paramAsStrings("projects")).setResolutions(request.paramAsStrings("resolutions")).setResolved(request.paramAsBoolean("resolved")).setRules(request.paramAsStrings("rules")).setSinceLeakPeriod(Boolean.valueOf(request.mandatoryParamAsBoolean("sinceLeakPeriod"))).setSort(request.param("s")).setSeverities(request.paramAsStrings("severities")).setStatuses(request.paramAsStrings("statuses")).setTags(request.paramAsStrings("tags")).setTypes(request.paramAsStrings("types")).setOwaspTop10(request.paramAsStrings("owaspTop10")).setSansTop25(request.paramAsStrings("sansTop25")).setCwe(request.paramAsStrings("cwe")).setSonarsourceSecurity(request.paramAsStrings("sonarsourceSecurity"));
    }

    private List<String> getLogins(DbSession dbSession, @Nullable List<String> assigneeLogins) {
        ArrayList<String> userLogins = new ArrayList<String>();
        for (String login : Optional.ofNullable(assigneeLogins).orElse(Collections.emptyList())) {
            if (LOGIN_MYSELF.equals(login)) {
                if (this.userSession.getLogin() == null) {
                    userLogins.add("<UNKNOWN>");
                    continue;
                }
                userLogins.add(this.userSession.getLogin());
                continue;
            }
            userLogins.add(login);
        }
        List userDtos = this.dbClient.userDao().selectByLogins(dbSession, userLogins);
        ImmutableList assigneeUuid = userDtos.stream().map(UserDto::getUuid).collect(Collectors.toList());
        if (assigneeLogins != null && ((List)MoreObjects.firstNonNull(assigneeUuid, Collections.emptyList())).isEmpty()) {
            assigneeUuid = ImmutableList.of((Object)"non-existent-uuid");
        }
        return assigneeUuid;
    }

    public void start() {
        this.isOnSonarCloud = this.config.getBoolean(ProcessProperties.Property.SONARCLOUD_ENABLED.getKey()).orElse(false);
    }

    public void stop() {
    }
}

