/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.io.Resources;
import java.util.Collection;
import java.util.Date;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.IssueFinder;
import org.sonar.server.issue.IssueUpdater;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.OperationResponseWriter;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;

public class SetTypeAction
implements IssuesWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final IssueFinder issueFinder;
    private final IssueFieldsSetter issueFieldsSetter;
    private final IssueUpdater issueUpdater;
    private final OperationResponseWriter responseWriter;
    private final System2 system2;

    public SetTypeAction(UserSession userSession, DbClient dbClient, IssueFinder issueFinder, IssueFieldsSetter issueFieldsSetter, IssueUpdater issueUpdater, OperationResponseWriter responseWriter, System2 system2) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.issueFinder = issueFinder;
        this.issueFieldsSetter = issueFieldsSetter;
        this.issueUpdater = issueUpdater;
        this.responseWriter = responseWriter;
        this.system2 = system2;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("set_type").setDescription("Change type of issue, for instance from 'code smell' to 'bug'.<br/>Requires the following permissions:<ul>  <li>'Authentication'</li>  <li>'Browse' rights on project of the specified issue</li>  <li>'Administer Issues' rights on project of the specified issue</li></ul>").setSince("5.5").setChangelog(new Change[]{new Change("6.5", "the database ids of the components are removed from the response"), new Change("6.5", "the response field components.uuid is deprecated. Use components.key instead.")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"set_type-example.json")).setPost(true);
        action.createParam("issue").setDescription("Issue key").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("type").setDescription("New type").setRequired(true).setPossibleValues((Collection)RuleType.names());
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String issueKey = request.mandatoryParam("issue");
        RuleType ruleType = RuleType.valueOf((String)request.mandatoryParam("type"));
        try (DbSession session = this.dbClient.openSession(false);){
            SearchResponseData preloadedSearchResponseData = this.setType(session, issueKey, ruleType);
            this.responseWriter.write(issueKey, preloadedSearchResponseData, request, response);
        }
    }

    private SearchResponseData setType(DbSession session, String issueKey, RuleType ruleType) {
        IssueDto issueDto = this.issueFinder.getByKey(session, issueKey);
        DefaultIssue issue = issueDto.toDefaultIssue();
        if (issue.isFromHotspot()) {
            throw new IllegalArgumentException("Changing type of a security hotspot is not permitted");
        }
        this.userSession.checkComponentUuidPermission("issueadmin", issue.projectUuid());
        IssueChangeContext context = IssueChangeContext.createUser((Date)new Date(this.system2.now()), (String)this.userSession.getUuid());
        if (this.issueFieldsSetter.setType(issue, ruleType, context)) {
            return this.issueUpdater.saveIssueAndPreloadSearchResponseData(session, issue, context, true);
        }
        return new SearchResponseData(issueDto);
    }
}

