/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.live;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.LiveMeasureComparator;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;
import org.sonar.server.measure.DebtRatingGrid;
import org.sonar.server.measure.Rating;
import org.sonar.server.measure.live.IssueCounter;
import org.sonar.server.measure.live.IssueMetricFormula;
import org.sonar.server.measure.live.IssueMetricFormulaFactory;
import org.sonar.server.measure.live.LiveMeasureComputer;
import org.sonar.server.measure.live.LiveQualityGateComputer;
import org.sonar.server.measure.live.MeasureMatrix;
import org.sonar.server.qualitygate.EvaluatedQualityGate;
import org.sonar.server.qualitygate.QualityGate;
import org.sonar.server.qualitygate.changeevent.QGChangeEvent;
import org.sonar.server.settings.ProjectConfigurationLoader;

public class LiveMeasureComputerImpl
implements LiveMeasureComputer {
    private final DbClient dbClient;
    private final IssueMetricFormulaFactory formulaFactory;
    private final LiveQualityGateComputer qGateComputer;
    private final ProjectConfigurationLoader projectConfigurationLoader;
    private final ProjectIndexers projectIndexer;

    public LiveMeasureComputerImpl(DbClient dbClient, IssueMetricFormulaFactory formulaFactory, LiveQualityGateComputer qGateComputer, ProjectConfigurationLoader projectConfigurationLoader, ProjectIndexers projectIndexer) {
        this.dbClient = dbClient;
        this.formulaFactory = formulaFactory;
        this.qGateComputer = qGateComputer;
        this.projectConfigurationLoader = projectConfigurationLoader;
        this.projectIndexer = projectIndexer;
    }

    @Override
    public List<QGChangeEvent> refresh(DbSession dbSession, Collection<ComponentDto> components) {
        if (components.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QGChangeEvent> result = new ArrayList<QGChangeEvent>();
        Map<String, List<ComponentDto>> componentsByProjectUuid = components.stream().collect(Collectors.groupingBy(ComponentDto::projectUuid));
        for (List<ComponentDto> groupedComponents : componentsByProjectUuid.values()) {
            Optional<QGChangeEvent> qgChangeEvent = this.refreshComponentsOnSameProject(dbSession, groupedComponents);
            qgChangeEvent.ifPresent(result::add);
        }
        return result;
    }

    private Optional<QGChangeEvent> refreshComponentsOnSameProject(DbSession dbSession, List<ComponentDto> touchedComponents) {
        List<ComponentDto> components = this.loadTreeOfComponents(dbSession, touchedComponents);
        ComponentDto project = LiveMeasureComputerImpl.findProject(components);
        OrganizationDto organization = this.loadOrganization(dbSession, project);
        BranchDto branch = this.loadBranch(dbSession, project);
        Optional lastAnalysis = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, project.uuid());
        if (!lastAnalysis.isPresent()) {
            return Optional.empty();
        }
        QualityGate qualityGate = this.qGateComputer.loadQualityGate(dbSession, organization, project, branch);
        Set<String> metricKeys = this.getKeysOfAllInvolvedMetrics(qualityGate);
        List metrics = this.dbClient.metricDao().selectByKeys(dbSession, metricKeys);
        Map metricsPerId = (Map)metrics.stream().collect(MoreCollectors.uniqueIndex(MetricDto::getId));
        List componentUuids = (List)components.stream().map(ComponentDto::uuid).collect(MoreCollectors.toArrayList((int)components.size()));
        List dbMeasures = this.dbClient.liveMeasureDao().selectByComponentUuidsAndMetricIds(dbSession, (Collection)componentUuids, metricsPerId.keySet());
        Metric.Level previousStatus = LiveMeasureComputerImpl.loadPreviousStatus(metrics, dbMeasures);
        Configuration config = this.projectConfigurationLoader.loadProjectConfiguration(dbSession, project);
        DebtRatingGrid debtRatingGrid = new DebtRatingGrid(config);
        MeasureMatrix matrix = new MeasureMatrix(components, metricsPerId.values(), dbMeasures);
        FormulaContextImpl context = new FormulaContextImpl(matrix, debtRatingGrid);
        long beginningOfLeak = LiveMeasureComputerImpl.getBeginningOfLeakPeriod(lastAnalysis, branch);
        components.forEach(c -> {
            IssueCounter issueCounter = new IssueCounter(this.dbClient.issueDao().selectIssueGroupsByBaseComponent(dbSession, c, beginningOfLeak));
            for (IssueMetricFormula formula : this.formulaFactory.getFormulas()) {
                if (!LiveMeasureComputerImpl.shouldUseLeakFormulas((SnapshotDto)lastAnalysis.get(), branch) && formula.isOnLeak()) continue;
                context.change(c, formula);
                try {
                    formula.compute(context, issueCounter);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Fail to compute " + formula.getMetric().getKey() + " on " + context.getComponent().getDbKey(), e);
                }
            }
        });
        EvaluatedQualityGate evaluatedQualityGate = this.qGateComputer.refreshGateStatus(project, qualityGate, matrix);
        matrix.getChanged().sorted((Comparator<LiveMeasureDto>)LiveMeasureComparator.INSTANCE).forEach(m -> this.dbClient.liveMeasureDao().insertOrUpdate(dbSession, m));
        this.projectIndexer.commitAndIndex(dbSession, Collections.singleton(project), ProjectIndexer.Cause.MEASURE_CHANGE);
        return Optional.of(new QGChangeEvent(project, branch, (SnapshotDto)lastAnalysis.get(), config, previousStatus, () -> Optional.of(evaluatedQualityGate)));
    }

    private static long getBeginningOfLeakPeriod(Optional<SnapshotDto> lastAnalysis, BranchDto branch) {
        if (LiveMeasureComputerImpl.isSLBorPR(branch)) {
            return 0L;
        }
        Optional<Long> beginningOfLeakPeriod = lastAnalysis.map(SnapshotDto::getPeriodDate);
        return beginningOfLeakPeriod.orElse(Long.MAX_VALUE);
    }

    private static boolean isSLBorPR(BranchDto branch) {
        return branch.getBranchType() == BranchType.SHORT || branch.getBranchType() == BranchType.PULL_REQUEST;
    }

    private static boolean shouldUseLeakFormulas(SnapshotDto lastAnalysis, BranchDto branch) {
        return lastAnalysis.getPeriodDate() != null || LiveMeasureComputerImpl.isSLBorPR(branch);
    }

    @CheckForNull
    private static Metric.Level loadPreviousStatus(List<MetricDto> metrics, List<LiveMeasureDto> dbMeasures) {
        MetricDto alertStatusMetric = metrics.stream().filter(m -> "alert_status".equals(m.getKey())).findAny().orElseThrow(() -> new IllegalStateException(String.format("Metric with key %s is not registered", "alert_status")));
        return dbMeasures.stream().filter(m -> m.getMetricId() == alertStatusMetric.getId().intValue()).map(LiveMeasureDto::getTextValue).filter(Objects::nonNull).map(m -> {
            try {
                return Metric.Level.valueOf((String)m);
            }
            catch (IllegalArgumentException e) {
                Loggers.get(LiveMeasureComputerImpl.class).trace("Failed to parse value of metric '{}'", m, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private List<ComponentDto> loadTreeOfComponents(DbSession dbSession, List<ComponentDto> touchedComponents) {
        HashSet<String> componentUuids = new HashSet<String>();
        for (ComponentDto component : touchedComponents) {
            componentUuids.add(component.uuid());
            componentUuids.addAll(component.getUuidPathAsList());
        }
        return this.dbClient.componentDao().selectByUuids(dbSession, componentUuids);
    }

    private Set<String> getKeysOfAllInvolvedMetrics(QualityGate gate) {
        HashSet<String> metricKeys = new HashSet<String>();
        for (Metric metric : this.formulaFactory.getFormulaMetrics()) {
            metricKeys.add(metric.getKey());
        }
        metricKeys.addAll(this.qGateComputer.getMetricsRelatedTo(gate));
        return metricKeys;
    }

    private static ComponentDto findProject(Collection<ComponentDto> components) {
        return components.stream().filter(ComponentDto::isRootProject).findFirst().orElseThrow(() -> new IllegalStateException("No project found in " + components));
    }

    private BranchDto loadBranch(DbSession dbSession, ComponentDto project) {
        return (BranchDto)this.dbClient.branchDao().selectByUuid(dbSession, project.uuid()).orElseThrow(() -> new IllegalStateException("Branch not found: " + project.uuid()));
    }

    private OrganizationDto loadOrganization(DbSession dbSession, ComponentDto project) {
        String organizationUuid = project.getOrganizationUuid();
        return (OrganizationDto)this.dbClient.organizationDao().selectByUuid(dbSession, organizationUuid).orElseThrow(() -> new IllegalStateException("No organization with UUID " + organizationUuid));
    }

    private static class FormulaContextImpl
    implements IssueMetricFormula.Context {
        private final MeasureMatrix matrix;
        private final DebtRatingGrid debtRatingGrid;
        private ComponentDto currentComponent;
        private IssueMetricFormula currentFormula;

        private FormulaContextImpl(MeasureMatrix matrix, DebtRatingGrid debtRatingGrid) {
            this.matrix = matrix;
            this.debtRatingGrid = debtRatingGrid;
        }

        private void change(ComponentDto component, IssueMetricFormula formula) {
            this.currentComponent = component;
            this.currentFormula = formula;
        }

        @Override
        public ComponentDto getComponent() {
            return this.currentComponent;
        }

        @Override
        public DebtRatingGrid getDebtRatingGrid() {
            return this.debtRatingGrid;
        }

        @Override
        public Optional<Double> getValue(Metric metric) {
            Optional<LiveMeasureDto> measure = this.matrix.getMeasure(this.currentComponent, metric.getKey());
            return measure.map(LiveMeasureDto::getValue);
        }

        @Override
        public Optional<Double> getLeakValue(Metric metric) {
            Optional<LiveMeasureDto> measure = this.matrix.getMeasure(this.currentComponent, metric.getKey());
            return measure.map(LiveMeasureDto::getVariation);
        }

        @Override
        public void setValue(double value) {
            String metricKey = this.currentFormula.getMetric().getKey();
            Preconditions.checkState((!this.currentFormula.isOnLeak() ? 1 : 0) != 0, (String)"Formula of metric %s accepts only leak values", (Object[])new Object[]{metricKey});
            this.matrix.setValue(this.currentComponent, metricKey, value);
        }

        @Override
        public void setLeakValue(double value) {
            String metricKey = this.currentFormula.getMetric().getKey();
            Preconditions.checkState((boolean)this.currentFormula.isOnLeak(), (String)"Formula of metric %s does not accept leak values", (Object[])new Object[]{metricKey});
            this.matrix.setLeakValue(this.currentComponent, metricKey, value);
        }

        @Override
        public void setValue(Rating value) {
            String metricKey = this.currentFormula.getMetric().getKey();
            Preconditions.checkState((!this.currentFormula.isOnLeak() ? 1 : 0) != 0, (String)"Formula of metric %s accepts only leak values", (Object[])new Object[]{metricKey});
            this.matrix.setValue(this.currentComponent, metricKey, value);
        }

        @Override
        public void setLeakValue(Rating value) {
            String metricKey = this.currentFormula.getMetric().getKey();
            Preconditions.checkState((boolean)this.currentFormula.isOnLeak(), (String)"Formula of metric %s does not accept leak values", (Object[])new Object[]{metricKey});
            this.matrix.setLeakValue(this.currentComponent, metricKey, value);
        }
    }
}

