/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.ComponentTreeData;

class SLBorPRMeasureFix {
    static final BiMap<String, String> METRICS = HashBiMap.create();

    private SLBorPRMeasureFix() {
    }

    static void addReplacementMetricKeys(Collection<String> metricKeys) {
        Set keysToAdd = metricKeys.stream().filter(arg_0 -> METRICS.containsKey(arg_0)).map(arg_0 -> METRICS.get(arg_0)).collect(Collectors.toSet());
        metricKeys.addAll(keysToAdd);
    }

    static void removeMetricsNotRequested(List<MetricDto> metrics, Set<String> requestedMetricKeys) {
        metrics.removeIf(m -> !requestedMetricKeys.contains(m.getKey()));
    }

    static void createReplacementMeasures(List<MetricDto> metrics, Table<String, MetricDto, ComponentTreeData.Measure> measuresByComponentUuidAndMetric, Set<String> requestedMetricKeys) {
        ImmutableMap metricByKey = Maps.uniqueIndex(metrics, MetricDto::getKey);
        for (MetricDto metric : measuresByComponentUuidAndMetric.columnKeySet()) {
            HashMap<String, ComponentTreeData.Measure> newEntries = new HashMap<String, ComponentTreeData.Measure>();
            String originalKey = (String)METRICS.inverse().get((Object)metric.getKey());
            if (originalKey == null || !requestedMetricKeys.contains(originalKey)) continue;
            for (Map.Entry e : measuresByComponentUuidAndMetric.column((Object)metric).entrySet()) {
                newEntries.put((String)e.getKey(), SLBorPRMeasureFix.copyMeasureToVariation((ComponentTreeData.Measure)e.getValue()));
            }
            MetricDto originalMetric = (MetricDto)metricByKey.get(originalKey);
            newEntries.forEach((k, v) -> measuresByComponentUuidAndMetric.put(k, (Object)originalMetric, v));
        }
        List toRemove = measuresByComponentUuidAndMetric.columnKeySet().stream().filter(m -> !requestedMetricKeys.contains(m.getKey())).collect(Collectors.toList());
        measuresByComponentUuidAndMetric.columnKeySet().removeAll(toRemove);
    }

    static void createReplacementMeasures(List<MetricDto> metrics, Map<MetricDto, LiveMeasureDto> measuresByMetric, Set<String> requestedMetricKeys) {
        ImmutableMap metricByKey = Maps.uniqueIndex(metrics, MetricDto::getKey);
        HashMap<MetricDto, LiveMeasureDto> newEntries = new HashMap<MetricDto, LiveMeasureDto>();
        for (Map.Entry<MetricDto, LiveMeasureDto> e2 : measuresByMetric.entrySet()) {
            String originalKey = (String)METRICS.inverse().get((Object)e2.getKey().getKey());
            if (originalKey == null || !requestedMetricKeys.contains(originalKey)) continue;
            MetricDto metricDto = (MetricDto)metricByKey.get(originalKey);
            newEntries.put(metricDto, SLBorPRMeasureFix.copyMeasureToVariation(e2.getValue(), metricDto.getId()));
        }
        measuresByMetric.entrySet().removeIf(e -> !requestedMetricKeys.contains(((MetricDto)e.getKey()).getKey()));
        measuresByMetric.putAll(newEntries);
    }

    private static ComponentTreeData.Measure copyMeasureToVariation(ComponentTreeData.Measure measure) {
        return new ComponentTreeData.Measure(null, null, measure.getValue());
    }

    private static LiveMeasureDto copyMeasureToVariation(LiveMeasureDto dto, Integer metricId) {
        LiveMeasureDto copy = new LiveMeasureDto();
        copy.setVariation(dto.getValue());
        copy.setProjectUuid(dto.getProjectUuid());
        copy.setComponentUuid(dto.getComponentUuid());
        copy.setMetricId(metricId.intValue());
        return copy;
    }

    static {
        METRICS.put((Object)"new_violations", (Object)"violations");
        METRICS.put((Object)"new_blocker_violations", (Object)"blocker_violations");
        METRICS.put((Object)"new_critical_violations", (Object)"critical_violations");
        METRICS.put((Object)"new_major_violations", (Object)"major_violations");
        METRICS.put((Object)"new_minor_violations", (Object)"minor_violations");
        METRICS.put((Object)"new_info_violations", (Object)"info_violations");
        METRICS.put((Object)"new_bugs", (Object)"bugs");
        METRICS.put((Object)"new_code_smells", (Object)"code_smells");
        METRICS.put((Object)"new_vulnerabilities", (Object)"vulnerabilities");
        METRICS.put((Object)"new_security_rating", (Object)"security_rating");
        METRICS.put((Object)"new_reliability_rating", (Object)"reliability_rating");
        METRICS.put((Object)"new_technical_debt", (Object)"sqale_index");
        METRICS.put((Object)"new_security_remediation_effort", (Object)"security_remediation_effort");
        METRICS.put((Object)"new_reliability_remediation_effort", (Object)"reliability_remediation_effort");
    }
}

