/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.metric.ws;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.ws.JsonWriterUtils;

public class MetricJsonWriter {
    public static final String FIELD_ID = "id";
    public static final String FIELD_KEY = "key";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_DOMAIN = "domain";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_DIRECTION = "direction";
    public static final String FIELD_QUALITATIVE = "qualitative";
    public static final String FIELD_HIDDEN = "hidden";
    public static final String FIELD_CUSTOM = "custom";
    public static final String FIELD_DECIMAL_SCALE = "decimalScale";
    public static final Set<String> OPTIONAL_FIELDS = ImmutableSet.of((Object)"name", (Object)"description", (Object)"domain", (Object)"direction", (Object)"qualitative", (Object)"hidden", (Object[])new String[]{"custom", "decimalScale"});
    public static final Set<String> MANDATORY_FIELDS = ImmutableSet.of((Object)"id", (Object)"key", (Object)"name", (Object)"domain", (Object)"type");
    public static final Set<String> ALL_FIELDS = ImmutableSet.copyOf((Collection)Sets.union(MANDATORY_FIELDS, OPTIONAL_FIELDS));

    private MetricJsonWriter() {
    }

    public static void write(JsonWriter json, List<MetricDto> metrics, Set<String> fieldsToReturn) {
        json.name("metrics");
        json.beginArray();
        for (MetricDto metric : metrics) {
            MetricJsonWriter.write(json, metric, fieldsToReturn);
        }
        json.endArray();
    }

    public static void write(JsonWriter json, MetricDto metric, Set<String> fieldsToReturn) {
        json.beginObject();
        json.prop(FIELD_ID, String.valueOf(metric.getId()));
        json.prop(FIELD_KEY, metric.getKey());
        json.prop(FIELD_TYPE, metric.getValueType());
        JsonWriterUtils.writeIfNeeded(json, metric.getShortName(), FIELD_NAME, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, metric.getDescription(), FIELD_DESCRIPTION, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, metric.getDomain(), FIELD_DOMAIN, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, metric.getDirection(), FIELD_DIRECTION, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, metric.isQualitative(), FIELD_QUALITATIVE, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, metric.isHidden(), FIELD_HIDDEN, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, metric.isUserManaged(), FIELD_CUSTOM, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, metric.getDecimalScale(), FIELD_DECIMAL_SCALE, fieldsToReturn);
        json.endObject();
    }
}

