/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.picocontainer.Startable;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.config.Configuration;
import org.sonar.api.notifications.Notification;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.notification.DefaultNotificationManager;
import org.sonar.server.notification.NotificationService;

@Properties(value={@Property(key="sonar.notifications.delay", defaultValue="60", name="Delay of notifications, in seconds", global=false), @Property(key="sonar.notifications.runningDelayBeforeReportingStatus", defaultValue="600", name="Delay before reporting notification status, in seconds", global=false)})
@ServerSide
public class NotificationDaemon
implements Startable {
    private static final String THREAD_NAME_PREFIX = "sq-notification-service-";
    private static final Logger LOG = Loggers.get(NotificationDaemon.class);
    public static final String PROPERTY_DELAY = "sonar.notifications.delay";
    public static final String PROPERTY_DELAY_BEFORE_REPORTING_STATUS = "sonar.notifications.runningDelayBeforeReportingStatus";
    private final long delayInSeconds;
    private final long delayBeforeReportingStatusInSeconds;
    private final DefaultNotificationManager manager;
    private final NotificationService service;
    private ScheduledExecutorService executorService;
    private boolean stopping = false;

    public NotificationDaemon(Configuration config, DefaultNotificationManager manager, NotificationService service) {
        this.delayInSeconds = (Long)config.getLong(PROPERTY_DELAY).get();
        this.delayBeforeReportingStatusInSeconds = (Long)config.getLong(PROPERTY_DELAY_BEFORE_REPORTING_STATUS).get();
        this.manager = manager;
        this.service = service;
    }

    public void start() {
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("sq-notification-service-%d").setPriority(1).build());
        this.executorService.scheduleWithFixedDelay(() -> {
            try {
                this.processQueue();
            }
            catch (Exception e) {
                LOG.error("Error in NotificationService", (Throwable)e);
            }
        }, 0L, this.delayInSeconds, TimeUnit.SECONDS);
        LOG.info("Notification service started (delay {} sec.)", (Object)this.delayInSeconds);
    }

    public void stop() {
        try {
            this.stopping = true;
            this.executorService.shutdown();
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Error during stop of notification service", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        LOG.info("Notification service stopped");
    }

    private synchronized void processQueue() {
        long start;
        long lastLog = start = this.now();
        long notifSentCount = 0L;
        Notification notifToSend = this.manager.getFromQueue();
        while (notifToSend != null) {
            notifSentCount += (long)this.service.deliverEmails(Collections.singleton(notifToSend));
            notifSentCount += (long)this.service.deliver(notifToSend);
            if (this.stopping) break;
            long now = this.now();
            if (now - lastLog > this.delayBeforeReportingStatusInSeconds * 1000L) {
                long remainingNotifCount = this.manager.count();
                lastLog = now;
                long spentTimeInMinutes = (now - start) / 60000L;
                this.log(notifSentCount, remainingNotifCount, spentTimeInMinutes);
            }
            notifToSend = this.manager.getFromQueue();
        }
    }

    @VisibleForTesting
    void log(long notifSentCount, long remainingNotifCount, long spentTimeInMinutes) {
        LOG.info("{} notifications sent during the past {} minutes and {} still waiting to be sent", new Object[]{notifSentCount, spentTimeInMinutes, remainingNotifCount});
    }

    @VisibleForTesting
    long now() {
        return System.currentTimeMillis();
    }
}

