/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.alm.ALM;
import org.sonar.db.alm.OrganizationAlmBindingDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.organization.OrganizationMemberDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserGroupDto;
import org.sonar.server.user.index.UserIndexer;
import org.sonar.server.usergroups.DefaultGroupFinder;

public class MemberUpdater {
    private final DbClient dbClient;
    private final DefaultGroupFinder defaultGroupFinder;
    private final UserIndexer userIndexer;

    public MemberUpdater(DbClient dbClient, DefaultGroupFinder defaultGroupFinder, UserIndexer userIndexer) {
        this.dbClient = dbClient;
        this.defaultGroupFinder = defaultGroupFinder;
        this.userIndexer = userIndexer;
    }

    public void addMember(DbSession dbSession, OrganizationDto organization, UserDto user) {
        this.addMembers(dbSession, organization, Collections.singletonList(user));
    }

    public void addMembers(DbSession dbSession, OrganizationDto organization, List<UserDto> users) {
        HashSet currentMemberIds = new HashSet(this.dbClient.organizationMemberDao().selectUserIdsByOrganizationUuid(dbSession, organization.getUuid()));
        List usersToAdd = (List)users.stream().filter(UserDto::isActive).filter(u -> !currentMemberIds.contains(u.getId())).collect(MoreCollectors.toList());
        if (usersToAdd.isEmpty()) {
            return;
        }
        usersToAdd.forEach(u -> this.addMemberInDb(dbSession, organization, (UserDto)u));
        this.userIndexer.commitAndIndex(dbSession, (Collection)usersToAdd);
    }

    private void addMemberInDb(DbSession dbSession, OrganizationDto organization, UserDto user) {
        this.dbClient.organizationMemberDao().insert(dbSession, new OrganizationMemberDto().setOrganizationUuid(organization.getUuid()).setUserId(user.getId()));
        this.dbClient.userGroupDao().insert(dbSession, new UserGroupDto().setGroupId(this.defaultGroupFinder.findDefaultGroup(dbSession, organization.getUuid()).getId().intValue()).setUserId(user.getId().intValue()));
    }

    public void removeMember(DbSession dbSession, OrganizationDto organization, UserDto user) {
        this.removeMembers(dbSession, organization, Collections.singletonList(user));
    }

    public void removeMembers(DbSession dbSession, OrganizationDto organization, List<UserDto> users) {
        HashSet currentMemberIds = new HashSet(this.dbClient.organizationMemberDao().selectUserIdsByOrganizationUuid(dbSession, organization.getUuid()));
        List usersToRemove = (List)users.stream().filter(UserDto::isActive).filter(u -> currentMemberIds.contains(u.getId())).collect(MoreCollectors.toList());
        if (usersToRemove.isEmpty()) {
            return;
        }
        Set userIdsToRemove = usersToRemove.stream().map(UserDto::getId).collect(Collectors.toSet());
        HashSet adminIds = new HashSet(this.dbClient.authorizationDao().selectUserIdsWithGlobalPermission(dbSession, organization.getUuid(), OrganizationPermission.ADMINISTER.getKey()));
        Preconditions.checkArgument((!Sets.difference(adminIds, userIdsToRemove).isEmpty() ? 1 : 0) != 0, (Object)"The last administrator member cannot be removed");
        usersToRemove.forEach(u -> this.removeMemberInDb(dbSession, organization, (UserDto)u));
        this.userIndexer.commitAndIndex(dbSession, (Collection)usersToRemove);
    }

    public void synchronizeUserOrganizationMembership(DbSession dbSession, UserDto user, ALM alm, Set<String> organizationAlmIds) {
        Set userOrganizationUuids = this.dbClient.organizationMemberDao().selectOrganizationUuidsByUser(dbSession, user.getId().intValue());
        Set userOrganizationUuidsWithMembersSyncEnabled = this.dbClient.organizationAlmBindingDao().selectByOrganizationUuids(dbSession, (Collection)userOrganizationUuids).stream().filter(OrganizationAlmBindingDto::isMembersSyncEnable).map(OrganizationAlmBindingDto::getOrganizationUuid).collect(Collectors.toSet());
        Set almOrganizationUuidsWithMembersSyncEnabled = this.dbClient.organizationAlmBindingDao().selectByOrganizationAlmIds(dbSession, alm, organizationAlmIds).stream().filter(OrganizationAlmBindingDto::isMembersSyncEnable).map(OrganizationAlmBindingDto::getOrganizationUuid).collect(Collectors.toSet());
        Sets.SetView organizationUuidsToBeAdded = Sets.difference(almOrganizationUuidsWithMembersSyncEnabled, userOrganizationUuidsWithMembersSyncEnabled);
        Sets.SetView organizationUuidsToBeRemoved = Sets.difference(userOrganizationUuidsWithMembersSyncEnabled, almOrganizationUuidsWithMembersSyncEnabled);
        Map allOrganizationsByUuid = (Map)this.dbClient.organizationDao().selectByUuids(dbSession, (Set)Sets.union((Set)organizationUuidsToBeAdded, (Set)organizationUuidsToBeRemoved)).stream().collect(MoreCollectors.uniqueIndex(OrganizationDto::getUuid));
        allOrganizationsByUuid.entrySet().stream().filter(arg_0 -> MemberUpdater.lambda$synchronizeUserOrganizationMembership$4((Set)organizationUuidsToBeAdded, arg_0)).forEach(entry -> this.addMemberInDb(dbSession, (OrganizationDto)entry.getValue(), user));
        allOrganizationsByUuid.entrySet().stream().filter(arg_0 -> MemberUpdater.lambda$synchronizeUserOrganizationMembership$6((Set)organizationUuidsToBeRemoved, arg_0)).forEach(entry -> this.removeMemberInDb(dbSession, (OrganizationDto)entry.getValue(), user));
    }

    private void removeMemberInDb(DbSession dbSession, OrganizationDto organization, UserDto user) {
        int userId = user.getId();
        String organizationUuid = organization.getUuid();
        this.dbClient.userPermissionDao().deleteOrganizationMemberPermissions(dbSession, organizationUuid, userId);
        this.dbClient.permissionTemplateDao().deleteUserPermissionsByOrganization(dbSession, organizationUuid, userId);
        this.dbClient.qProfileEditUsersDao().deleteByOrganizationAndUser(dbSession, organization, user);
        this.dbClient.userGroupDao().deleteByOrganizationAndUser(dbSession, organizationUuid, userId);
        this.dbClient.propertiesDao().deleteByOrganizationAndUser(dbSession, organizationUuid, userId);
        this.dbClient.propertiesDao().deleteByOrganizationAndMatchingLogin(dbSession, organizationUuid, user.getLogin(), Collections.singletonList("sonar.issues.defaultAssigneeLogin"));
        this.dbClient.organizationMemberDao().delete(dbSession, organizationUuid, Integer.valueOf(userId));
    }

    private static /* synthetic */ boolean lambda$synchronizeUserOrganizationMembership$6(Set organizationUuidsToBeRemoved, Map.Entry entry) {
        return organizationUuidsToBeRemoved.contains(entry.getKey());
    }

    private static /* synthetic */ boolean lambda$synchronizeUserOrganizationMembership$4(Set organizationUuidsToBeAdded, Map.Entry entry) {
        return organizationUuidsToBeAdded.contains(entry.getKey());
    }
}

