/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission;

import java.util.List;
import java.util.Optional;
import org.sonar.api.web.UserRole;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.GroupPermissionDto;
import org.sonar.server.permission.GroupPermissionChange;
import org.sonar.server.permission.PermissionChange;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.ws.RequestValidator;
import org.sonar.server.ws.WsUtils;

public class GroupPermissionChanger {
    private final DbClient dbClient;

    public GroupPermissionChanger(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public boolean apply(DbSession dbSession, GroupPermissionChange change) {
        GroupPermissionChanger.ensureConsistencyWithVisibility(change);
        if (GroupPermissionChanger.isImplicitlyAlreadyDone(change)) {
            return false;
        }
        switch (change.getOperation()) {
            case ADD: {
                return this.addPermission(dbSession, change);
            }
            case REMOVE: {
                return this.removePermission(dbSession, change);
            }
        }
        throw new UnsupportedOperationException("Unsupported permission change: " + (Object)((Object)change.getOperation()));
    }

    private static boolean isImplicitlyAlreadyDone(GroupPermissionChange change) {
        return change.getProjectId().map(projectId -> GroupPermissionChanger.isImplicitlyAlreadyDone(projectId, change)).orElse(false);
    }

    private static boolean isImplicitlyAlreadyDone(ProjectId projectId, GroupPermissionChange change) {
        return GroupPermissionChanger.isAttemptToAddPublicPermissionToPublicComponent(change, projectId) || GroupPermissionChanger.isAttemptToRemovePermissionFromAnyoneOnPrivateComponent(change, projectId);
    }

    private static boolean isAttemptToAddPublicPermissionToPublicComponent(GroupPermissionChange change, ProjectId projectId) {
        return !projectId.isPrivate() && change.getOperation() == PermissionChange.Operation.ADD && UserRole.PUBLIC_PERMISSIONS.contains(change.getPermission());
    }

    private static boolean isAttemptToRemovePermissionFromAnyoneOnPrivateComponent(GroupPermissionChange change, ProjectId projectId) {
        return projectId.isPrivate() && change.getOperation() == PermissionChange.Operation.REMOVE && change.getGroupIdOrAnyone().isAnyone();
    }

    private static void ensureConsistencyWithVisibility(GroupPermissionChange change) {
        change.getProjectId().ifPresent(projectId -> {
            WsUtils.checkRequest(!GroupPermissionChanger.isAttemptToAddPermissionToAnyoneOnPrivateComponent(change, projectId), "No permission can be granted to Anyone on a private component", new Object[0]);
            WsUtils.checkRequest(!GroupPermissionChanger.isAttemptToRemovePublicPermissionFromPublicComponent(change, projectId), "Permission %s can't be removed from a public component", change.getPermission());
        });
    }

    private static boolean isAttemptToAddPermissionToAnyoneOnPrivateComponent(GroupPermissionChange change, ProjectId projectId) {
        return projectId.isPrivate() && change.getOperation() == PermissionChange.Operation.ADD && change.getGroupIdOrAnyone().isAnyone();
    }

    private static boolean isAttemptToRemovePublicPermissionFromPublicComponent(GroupPermissionChange change, ProjectId projectId) {
        return !projectId.isPrivate() && change.getOperation() == PermissionChange.Operation.REMOVE && UserRole.PUBLIC_PERMISSIONS.contains(change.getPermission());
    }

    private boolean addPermission(DbSession dbSession, GroupPermissionChange change) {
        if (this.loadExistingPermissions(dbSession, change).contains(change.getPermission())) {
            return false;
        }
        RequestValidator.validateNotAnyoneAndAdminPermission(change.getPermission(), change.getGroupIdOrAnyone());
        GroupPermissionDto addedDto = new GroupPermissionDto().setRole(change.getPermission()).setOrganizationUuid(change.getOrganizationUuid()).setGroupId(change.getGroupIdOrAnyone().getId()).setResourceId(change.getNullableProjectId());
        this.dbClient.groupPermissionDao().insert(dbSession, addedDto);
        return true;
    }

    private boolean removePermission(DbSession dbSession, GroupPermissionChange change) {
        if (!this.loadExistingPermissions(dbSession, change).contains(change.getPermission())) {
            return false;
        }
        this.checkIfRemainingGlobalAdministrators(dbSession, change);
        this.dbClient.groupPermissionDao().delete(dbSession, change.getPermission(), change.getOrganizationUuid(), change.getGroupIdOrAnyone().getId(), change.getNullableProjectId());
        return true;
    }

    private List<String> loadExistingPermissions(DbSession dbSession, GroupPermissionChange change) {
        Optional<ProjectId> projectId = change.getProjectId();
        if (projectId.isPresent()) {
            return this.dbClient.groupPermissionDao().selectProjectPermissionsOfGroup(dbSession, change.getOrganizationUuid(), change.getGroupIdOrAnyone().getId(), projectId.get().getId());
        }
        return this.dbClient.groupPermissionDao().selectGlobalPermissionsOfGroup(dbSession, change.getOrganizationUuid(), change.getGroupIdOrAnyone().getId());
    }

    private void checkIfRemainingGlobalAdministrators(DbSession dbSession, GroupPermissionChange change) {
        if ("admin".equals(change.getPermission()) && !change.getGroupIdOrAnyone().isAnyone() && !change.getProjectId().isPresent()) {
            int remaining = this.dbClient.authorizationDao().countUsersWithGlobalPermissionExcludingGroup(dbSession, change.getOrganizationUuid(), "admin", change.getGroupIdOrAnyone().getId().intValue());
            WsUtils.checkRequest(remaining > 0, "Last group with permission '%s'. Permission cannot be removed.", "admin");
        }
    }
}

