/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.sonar.api.SonarRuntime;
import org.sonar.api.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ServerSide
public class LogServerVersion
implements Startable {
    private static final Logger LOG = Loggers.get(LogServerVersion.class);
    private final SonarRuntime runtime;

    public LogServerVersion(SonarRuntime runtime) {
        this.runtime = runtime;
    }

    public void start() {
        String scmRevision = LogServerVersion.read("/build.properties").getProperty("Implementation-Build");
        Version version = this.runtime.getApiVersion();
        LOG.info("SonarQube {}", (Object)Joiner.on((String)" / ").skipNulls().join((Object)"Server", (Object)version, new Object[]{scmRevision}));
    }

    public void stop() {
    }

    private static Properties read(String filePath) {
        Properties properties;
        block8: {
            InputStream stream = LogServerVersion.class.getResourceAsStream(filePath);
            try {
                Properties properties2 = new Properties();
                properties2.load(stream);
                properties = properties2;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Fail to read file " + filePath + " from classpath", e);
                }
            }
            stream.close();
        }
        return properties;
    }
}

