/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring.cluster;

import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.server.ServerSide;
import org.sonar.process.ProcessProperties;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.platform.OfficialDistribution;

@ServerSide
public class NodeSystemSection
implements SystemInfoSection {
    private final Configuration config;
    private final Server server;
    private final OfficialDistribution officialDistribution;

    public NodeSystemSection(Configuration config, Server server, OfficialDistribution officialDistribution) {
        this.config = config;
        this.server = server;
        this.officialDistribution = officialDistribution;
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("System");
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Version", (String)this.server.getVersion());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Official Distribution", (Boolean)this.officialDistribution.check());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Home Dir", (String)this.config.get(ProcessProperties.Property.PATH_HOME.getKey()).orElse(null));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Data Dir", (String)this.config.get(ProcessProperties.Property.PATH_DATA.getKey()).orElse(null));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Temp Dir", (String)this.config.get(ProcessProperties.Property.PATH_TEMP.getKey()).orElse(null));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Processors", (long)Runtime.getRuntime().availableProcessors());
        return protobuf.build();
    }
}

