/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.Resources;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.plugin.PluginDto;
import org.sonar.server.plugins.InstalledPlugin;
import org.sonar.server.plugins.PluginFileSystem;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.plugins.ws.PluginWSCommons;
import org.sonar.server.plugins.ws.PluginsWsAction;
import org.sonar.updatecenter.common.Plugin;

public class InstalledAction
implements PluginsWsAction {
    private static final String ARRAY_PLUGINS = "plugins";
    private static final String FIELD_CATEGORY = "category";
    private final PluginFileSystem pluginFileSystem;
    private final UpdateCenterMatrixFactory updateCenterMatrixFactory;
    private final DbClient dbClient;

    public InstalledAction(PluginFileSystem pluginFileSystem, UpdateCenterMatrixFactory updateCenterMatrixFactory, DbClient dbClient) {
        this.pluginFileSystem = pluginFileSystem;
        this.updateCenterMatrixFactory = updateCenterMatrixFactory;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("installed").setDescription("Get the list of all the plugins installed on the SonarQube instance, sorted by plugin name.").setSince("5.2").setChangelog(new Change[]{new Change("6.6", "The 'filename' field is added"), new Change("6.6", "The 'fileHash' field is added"), new Change("6.6", "The 'sonarLintSupported' field is added"), new Change("6.6", "The 'updatedAt' field is added"), new Change("7.0", "The fields 'compressedHash' and 'compressedFilename' are added")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-installed_plugins.json"));
        action.createFieldsParam(Collections.singleton(FIELD_CATEGORY)).setDescription(String.format("Comma-separated list of the additional fields to be returned in response. No additional field is returned by default. Possible values are:<ul><li>%s - category as defined in the Update Center. A connection to the Update Center is needed</li></lu>", FIELD_CATEGORY)).setSince("5.6");
    }

    public void handle(Request request, Response response) throws Exception {
        Map dtosByKey;
        SortedSet<InstalledPlugin> installedPlugins = this.loadInstalledPlugins();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            dtosByKey = this.dbClient.pluginDao().selectAll(dbSession).stream().collect(Collectors.toMap(PluginDto::getKee, Function.identity()));
        }
        JsonWriter json = response.newJsonWriter();
        json.setSerializeEmptys(false);
        json.beginObject();
        List additionalFields = request.paramAsStrings("f");
        Map updateCenterPlugins = additionalFields == null || additionalFields.isEmpty() ? Collections.emptyMap() : PluginWSCommons.compatiblePluginsByKey(this.updateCenterMatrixFactory);
        json.name(ARRAY_PLUGINS);
        json.beginArray();
        for (InstalledPlugin installedPlugin : ImmutableSortedSet.copyOf(PluginWSCommons.NAME_KEY_COMPARATOR, installedPlugins)) {
            PluginDto pluginDto = (PluginDto)dtosByKey.get(installedPlugin.getPluginInfo().getKey());
            Objects.requireNonNull(pluginDto, () -> String.format("Plugin %s is installed but not in DB", installedPlugin.getPluginInfo().getKey()));
            Plugin updateCenterPlugin = (Plugin)updateCenterPlugins.get(installedPlugin.getPluginInfo().getKey());
            PluginWSCommons.writePluginInfo(json, installedPlugin.getPluginInfo(), PluginWSCommons.categoryOrNull(updateCenterPlugin), pluginDto, installedPlugin);
        }
        json.endArray();
        json.endObject();
        json.close();
    }

    private SortedSet<InstalledPlugin> loadInstalledPlugins() {
        return ImmutableSortedSet.copyOf(PluginWSCommons.NAME_KEY_COMPARATOR, this.pluginFileSystem.getInstalledFiles());
    }
}

