/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sonar.server.project.Project;

public final class RekeyedProject {
    private final Project project;
    private final String previousKey;

    public RekeyedProject(Project project, String previousKey) {
        this.project = (Project)Preconditions.checkNotNull((Object)project, (Object)"project can't be null");
        this.previousKey = (String)Preconditions.checkNotNull((Object)previousKey, (Object)"previousKey can't be null");
    }

    public Project getProject() {
        return this.project;
    }

    public String getPreviousKey() {
        return this.previousKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RekeyedProject that = (RekeyedProject)o;
        return Objects.equals(this.project, that.project) && Objects.equals(this.previousKey, that.previousKey);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.previousKey);
    }

    public String toString() {
        return "RekeyedProject{project=" + this.project + ", previousKey='" + this.previousKey + '\'' + '}';
    }
}

