/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.project.Visibility;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class GhostsAction
implements ProjectsWsAction {
    private static final String PARAM_ORGANIZATION = "organization";
    private static final String ACTION = "ghosts";
    private static final Set<String> POSSIBLE_FIELDS = Sets.newHashSet((Object[])new String[]{"uuid", "key", "name", "creationDate", "visibility"});
    private final DbClient dbClient;
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public GhostsAction(DbClient dbClient, UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION);
        action.setChangelog(new Change[]{new Change("6.4", "The 'uuid' field is deprecated in the response")});
        action.setDescription("List ghost projects.<br> With the current architecture, it's no more possible to have invisible ghost projects. Therefore, the web service is deprecated.<br> Requires 'Administer System' permission.").setResponseExample(Resources.getResource(this.getClass(), (String)"ghosts-example.json")).setSince("5.2").setDeprecatedSince("6.6").addPagingParams(100, 500).addFieldsParam(POSSIBLE_FIELDS).addSearchQuery("sonar", new String[]{"names", "keys"}).setHandler((RequestHandler)this);
        action.createParam(PARAM_ORGANIZATION).setDescription("Organization key").setRequired(false).setInternal(true).setSince("6.3");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        SearchOptions searchOptions = new SearchOptions().setPage(request.mandatoryParamAsInt("p"), request.mandatoryParamAsInt("ps"));
        Set<String> desiredFields = GhostsAction.fieldsToReturn(request.paramAsStrings("f"));
        String query = request.param("q");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.getOrganization(dbSession, request);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            long nbOfProjects = this.dbClient.componentDao().countGhostProjects(dbSession, organization.getUuid(), query);
            List projects = this.dbClient.componentDao().selectGhostProjects(dbSession, organization.getUuid(), query, searchOptions.getOffset(), searchOptions.getLimit());
            try (JsonWriter json = response.newJsonWriter();){
                json.beginObject();
                GhostsAction.writeProjects(json, projects, desiredFields);
                searchOptions.writeJson(json, nbOfProjects);
                json.endObject();
            }
        }
    }

    private OrganizationDto getOrganization(DbSession dbSession, Request request) {
        String organizationKey = (String)request.getParam(PARAM_ORGANIZATION).or(() -> ((DefaultOrganization)this.defaultOrganizationProvider.get()).getKey());
        return (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organization for key '%s'", organizationKey);
    }

    private static void writeProjects(JsonWriter json, List<ComponentDto> projects, Set<String> fieldsToReturn) {
        json.name("projects");
        json.beginArray();
        for (ComponentDto project : projects) {
            json.beginObject();
            json.prop("uuid", project.uuid());
            GhostsAction.writeIfWished(json, "key", project.getDbKey(), fieldsToReturn);
            GhostsAction.writeIfWished(json, "name", project.name(), fieldsToReturn);
            GhostsAction.writeIfWished(json, "creationDate", project.getCreatedAt(), fieldsToReturn);
            GhostsAction.writeIfWished(json, "visibility", project.isPrivate() ? Visibility.PRIVATE.getLabel() : Visibility.PUBLIC.getLabel(), fieldsToReturn);
            json.endObject();
        }
        json.endArray();
    }

    private static void writeIfWished(JsonWriter json, String key, String value, Set<String> fieldsToReturn) {
        if (fieldsToReturn.contains(key)) {
            json.prop(key, value);
        }
    }

    private static void writeIfWished(JsonWriter json, String key, Date value, Set<String> desiredFields) {
        if (desiredFields.contains(key)) {
            json.propDateTime(key, value);
        }
    }

    private static Set<String> fieldsToReturn(@Nullable List<String> desiredFieldsFromRequest) {
        if (desiredFieldsFromRequest == null) {
            return POSSIBLE_FIELDS;
        }
        return Sets.newHashSet(desiredFieldsFromRequest);
    }
}

