/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.projectanalysis.ws.ProjectAnalysesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class SetBaselineAction
implements ProjectAnalysesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public SetBaselineAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("set_baseline").setDescription("Set an analysis as the baseline of the New Code Period on a project or a long-lived branch.<br/>This manually set baseline overrides the `sonar.leak.period` setting.<br/>Requires one of the following permissions:<ul>  <li>'Administer System'</li>  <li>'Administer' rights on the specified project</li></ul>").setSince("7.7").setPost(true).setHandler((RequestHandler)this);
        action.createParam("project").setDescription("Project key").setRequired(true);
        action.createParam("branch").setDescription("Branch key");
        action.createParam("analysis").setDescription("Analysis key").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setRequired(true);
    }

    public void handle(Request httpRequest, Response httpResponse) throws Exception {
        this.doHandle(httpRequest);
        WsUtils.writeProtobuf((Message)Empty.newBuilder().build(), httpRequest, httpResponse);
    }

    private void doHandle(Request request) {
        String projectKey = request.mandatoryParam("project");
        String branchKey = StringUtils.trimToNull((String)request.param("branch"));
        String analysisUuid = request.mandatoryParam("analysis");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto projectBranch = this.getProjectBranch(dbSession, projectKey, branchKey);
            SnapshotDto analysis = this.getAnalysis(dbSession, analysisUuid);
            this.checkRequest(dbSession, projectBranch, branchKey, analysis);
            this.dbClient.branchDao().updateManualBaseline(dbSession, projectBranch.uuid(), analysis.getUuid());
            dbSession.commit();
        }
    }

    private ComponentDto getProjectBranch(DbSession dbSession, String projectKey, @Nullable String branchKey) {
        if (branchKey == null) {
            return this.componentFinder.getByUuidOrKey(dbSession, null, projectKey, ComponentFinder.ParamNames.PROJECT_ID_AND_KEY);
        }
        ComponentDto project = this.componentFinder.getByKeyAndBranch(dbSession, projectKey, branchKey);
        BranchDto branchDto = (BranchDto)this.dbClient.branchDao().selectByUuid(dbSession, project.uuid()).orElseThrow(() -> new NotFoundException(String.format("Branch '%s' is not found", branchKey)));
        Preconditions.checkArgument((branchDto.getBranchType() == BranchType.LONG ? 1 : 0) != 0, (String)"Not a long-living branch: '%s'", (Object[])new Object[]{branchKey});
        return project;
    }

    private SnapshotDto getAnalysis(DbSession dbSession, String analysisUuid) {
        return (SnapshotDto)this.dbClient.snapshotDao().selectByUuid(dbSession, analysisUuid).orElseThrow(() -> new NotFoundException(String.format("Analysis '%s' is not found", analysisUuid)));
    }

    private void checkRequest(DbSession dbSession, ComponentDto projectBranch, @Nullable String branchKey, SnapshotDto analysis) {
        boolean analysisMatchesProjectBranch;
        this.userSession.checkComponentPermission("admin", projectBranch);
        ComponentDto project = this.dbClient.componentDao().selectByUuid(dbSession, analysis.getComponentUuid()).orElse(null);
        boolean bl = analysisMatchesProjectBranch = project != null && projectBranch.uuid().equals(project.uuid());
        if (branchKey != null) {
            Preconditions.checkArgument((boolean)analysisMatchesProjectBranch, (String)"Analysis '%s' does not belong to branch '%s' of project '%s'", (Object[])new Object[]{analysis.getUuid(), branchKey, projectBranch.getKey()});
        } else {
            Preconditions.checkArgument((boolean)analysisMatchesProjectBranch, (String)"Analysis '%s' does not belong to project '%s'", (Object[])new Object[]{analysis.getUuid(), projectBranch.getKey()});
        }
    }
}

