/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projecttag.ws;

import com.google.protobuf.Message;
import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.measure.index.ProjectMeasuresIndex;
import org.sonar.server.projecttag.ws.ProjectTagsWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.ProjectTags;

public class SearchAction
implements ProjectTagsWsAction {
    private final ProjectMeasuresIndex index;

    public SearchAction(ProjectMeasuresIndex index) {
        this.index = index;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setDescription("Search tags").setSince("6.4").setResponseExample(this.getClass().getResource("search-example.json")).setHandler((RequestHandler)this);
        action.addSearchQuery("off", new String[]{"tags"});
        action.createPageSize(10, 100);
    }

    public void handle(Request request, Response response) throws Exception {
        ProjectTags.SearchResponse wsResponse = this.doHandle(request);
        WsUtils.writeProtobuf((Message)wsResponse, request, response);
    }

    private ProjectTags.SearchResponse doHandle(Request request) {
        List<String> tags = this.index.searchTags(request.param("q"), request.mandatoryParamAsInt("ps"));
        return ProjectTags.SearchResponse.newBuilder().addAllTags(tags).build();
    }
}

