/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projecttag.ws;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;
import org.sonar.server.projecttag.ws.ProjectTagsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class SetAction
implements ProjectTagsWsAction {
    private static final String VALID_TAG_REGEXP = "[a-z0-9+#\\-.]+$";
    private static final String PARAM_PROJECT = "project";
    private static final String PARAM_TAGS = "tags";
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final ProjectIndexers projectIndexers;

    public SetAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession, ProjectIndexers projectIndexers) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.projectIndexers = projectIndexers;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("set").setDescription("Set tags on a project.<br>Requires the following permission: 'Administer' rights on the specified project").setSince("6.4").setPost(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_PROJECT).setDescription("Project key").setRequired(true).setExampleValue((Object)"my_project");
        action.createParam(PARAM_TAGS).setDescription("Comma-separated list of tags").setRequired(true).setExampleValue((Object)"finance, offshore");
    }

    public void handle(Request request, Response response) throws Exception {
        String projectKey = request.mandatoryParam(PARAM_PROJECT);
        List tags = (List)request.mandatoryParamAsStrings(PARAM_TAGS).stream().filter(StringUtils::isNotBlank).map(t -> t.toLowerCase(Locale.ENGLISH)).map(SetAction::checkTag).distinct().collect(MoreCollectors.toList());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto project = this.componentFinder.getByKey(dbSession, projectKey);
            WsUtils.checkRequest("TRK".equals(project.qualifier()), "Component '%s' is not a project", project.getDbKey());
            this.userSession.checkComponentPermission("admin", project);
            project.setTags(tags);
            this.dbClient.componentDao().updateTags(dbSession, project);
            this.projectIndexers.commitAndIndex(dbSession, Collections.singletonList(project), ProjectIndexer.Cause.PROJECT_TAGS_UPDATE);
        }
        response.noContent();
    }

    private static String checkTag(String tag) {
        WsUtils.checkRequest(tag.matches(VALID_TAG_REGEXP), "Tag '%s' is invalid. Project tags accept only the characters: a-z, 0-9, '+', '-', '#', '.'", tag);
        return tag;
    }
}

