/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.notifications.Notification;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.notification.EmailNotificationHandler;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.email.EmailNotificationChannel;
import org.sonar.server.qualityprofile.BuiltInQPChangeNotification;

public class BuiltInQPChangeNotificationHandler
extends EmailNotificationHandler<BuiltInQPChangeNotification> {
    private final DbClient dbClient;

    public BuiltInQPChangeNotificationHandler(DbClient dbClient, EmailNotificationChannel emailNotificationChannel) {
        super(emailNotificationChannel);
        this.dbClient = dbClient;
    }

    public Optional<NotificationDispatcherMetadata> getMetadata() {
        return Optional.empty();
    }

    public Class<BuiltInQPChangeNotification> getNotificationClass() {
        return BuiltInQPChangeNotification.class;
    }

    public Set<EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(Collection<BuiltInQPChangeNotification> notifications) {
        try (DbSession session = this.dbClient.openSession(false);){
            Set set = (Set)this.dbClient.authorizationDao().selectQualityProfileAdministratorLogins(session).stream().flatMap(t -> notifications.stream().map(notification -> new EmailNotificationChannel.EmailDeliveryRequest(t.getEmail(), (Notification)notification))).collect(MoreCollectors.toSet());
            return set;
        }
    }
}

