/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.collect.Multimap;
import java.util.Collection;
import org.sonar.api.config.Configuration;
import org.sonar.api.notifications.Notification;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.server.notification.NotificationManager;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.BuiltInQPChangeNotificationBuilder;
import org.sonar.server.qualityprofile.QProfileName;

public class BuiltInQualityProfilesUpdateListener {
    private final NotificationManager notificationManager;
    private final Languages languages;
    private final Configuration config;

    public BuiltInQualityProfilesUpdateListener(NotificationManager notificationManager, Languages languages, Configuration config) {
        this.notificationManager = notificationManager;
        this.languages = languages;
        this.config = config;
    }

    void onChange(Multimap<QProfileName, ActiveRuleChange> changedProfiles, long startDate, long endDate) {
        if (this.config.getBoolean("sonar.builtInQualityProfiles.disableNotificationOnUpdate").orElse(false).booleanValue()) {
            return;
        }
        BuiltInQPChangeNotificationBuilder builder = new BuiltInQPChangeNotificationBuilder();
        changedProfiles.keySet().stream().map(changedProfile -> {
            String profileName = changedProfile.getName();
            Language language = this.languages.get(changedProfile.getLanguage());
            Collection activeRuleChanges = changedProfiles.get(changedProfile);
            int newRules = (int)activeRuleChanges.stream().map(ActiveRuleChange::getType).filter(arg_0 -> ActiveRuleChange.Type.ACTIVATED.equals(arg_0)).count();
            int updatedRules = (int)activeRuleChanges.stream().map(ActiveRuleChange::getType).filter(arg_0 -> ActiveRuleChange.Type.UPDATED.equals(arg_0)).count();
            int removedRules = (int)activeRuleChanges.stream().map(ActiveRuleChange::getType).filter(arg_0 -> ActiveRuleChange.Type.DEACTIVATED.equals(arg_0)).count();
            return BuiltInQPChangeNotificationBuilder.Profile.newBuilder().setProfileName(profileName).setLanguageKey(language.getKey()).setLanguageName(language.getName()).setNewRules(newRules).setUpdatedRules(updatedRules).setRemovedRules(removedRules).setStartDate(startDate).setEndDate(endDate).build();
        }).forEach(builder::addProfile);
        this.notificationManager.scheduleForSending((Notification)builder.build());
    }
}

