/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.server.qualityprofile.DescendantProfilesSupplier;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.ws.WsUtils;

class RuleActivationContext {
    private final long date;
    private final RulesProfileDto baseRulesProfile;
    private final Map<String, QProfileDto> profilesByUuid = new HashMap<String, QProfileDto>();
    private final ListMultimap<String, QProfileDto> profilesByParentUuid = ArrayListMultimap.create();
    private final Map<Integer, RuleWrapper> rulesById = new HashMap<Integer, RuleWrapper>();
    private final Map<ActiveRuleKey, ActiveRuleWrapper> activeRulesByKey = new HashMap<ActiveRuleKey, ActiveRuleWrapper>();
    private RulesProfileDto currentRulesProfile;
    private Collection<QProfileDto> currentProfiles;
    private RuleWrapper currentRule;
    private ActiveRuleWrapper currentActiveRule;
    private ActiveRuleWrapper currentParentActiveRule;
    private boolean descendantsLoaded = false;
    private final DescendantProfilesSupplier descendantProfilesSupplier;

    private RuleActivationContext(Builder builder) {
        this.date = builder.date;
        this.descendantProfilesSupplier = builder.descendantProfilesSupplier;
        ListMultimap paramsByRuleId = (ListMultimap)builder.ruleParams.stream().collect(MoreCollectors.index(RuleParamDto::getRuleId));
        for (RuleDefinitionDto rule : builder.rules) {
            RuleWrapper wrapper = new RuleWrapper(rule, paramsByRuleId.get((Object)rule.getId()));
            this.rulesById.put(rule.getId(), wrapper);
        }
        this.baseRulesProfile = builder.baseRulesProfile;
        this.register(builder.profiles);
        this.register(builder.activeRules, builder.activeRuleParams);
    }

    private void register(Collection<QProfileDto> profiles) {
        for (QProfileDto profile : profiles) {
            this.profilesByUuid.put(profile.getKee(), profile);
            if (profile.getParentKee() == null) continue;
            this.profilesByParentUuid.put((Object)profile.getParentKee(), (Object)profile);
        }
    }

    private void register(Collection<ActiveRuleDto> activeRules, Collection<ActiveRuleParamDto> activeRuleParams) {
        ListMultimap paramsByActiveRuleId = (ListMultimap)activeRuleParams.stream().collect(MoreCollectors.index(ActiveRuleParamDto::getActiveRuleId));
        for (ActiveRuleDto activeRule : activeRules) {
            ActiveRuleWrapper wrapper = new ActiveRuleWrapper(activeRule, paramsByActiveRuleId.get((Object)activeRule.getId()));
            this.activeRulesByKey.put(activeRule.getKey(), wrapper);
        }
    }

    long getDate() {
        return this.date;
    }

    RuleWrapper getRule() {
        Preconditions.checkState((this.currentRule != null ? 1 : 0) != 0, (Object)"Rule has not been set yet");
        return this.currentRule;
    }

    @CheckForNull
    String getRequestedParamValue(RuleActivation request, String key) {
        if (this.currentRule.rule.isCustomRule()) {
            return null;
        }
        return request.getParameter(key);
    }

    boolean hasRequestedParamValue(RuleActivation request, String key) {
        return request.hasParameter(key);
    }

    RulesProfileDto getRulesProfile() {
        Preconditions.checkState((this.currentRulesProfile != null ? 1 : 0) != 0, (Object)"Rule profile has not been set yet");
        return this.currentRulesProfile;
    }

    @CheckForNull
    ActiveRuleWrapper getActiveRule() {
        return this.currentActiveRule;
    }

    @CheckForNull
    ActiveRuleWrapper getParentActiveRule() {
        return this.currentParentActiveRule;
    }

    boolean isCascading() {
        return this.currentRulesProfile != null && !this.currentRulesProfile.getKee().equals(this.baseRulesProfile.getKee());
    }

    Collection<QProfileDto> getProfiles() {
        Preconditions.checkState((this.currentProfiles != null ? 1 : 0) != 0, (Object)"Profiles have not been set yet");
        return this.currentProfiles;
    }

    Collection<QProfileDto> getChildProfiles() {
        this.loadDescendants();
        return this.getProfiles().stream().flatMap(p -> this.profilesByParentUuid.get((Object)p.getKee()).stream()).collect(Collectors.toList());
    }

    private void loadDescendants() {
        if (this.descendantsLoaded) {
            return;
        }
        Collection baseProfiles = (Collection)this.profilesByUuid.values().stream().filter(p -> p.getRulesProfileUuid().equals(this.baseRulesProfile.getKee())).collect(MoreCollectors.toArrayList((int)this.profilesByUuid.size()));
        DescendantProfilesSupplier.Result result = this.descendantProfilesSupplier.get(baseProfiles, this.rulesById.keySet());
        this.register(result.getProfiles());
        this.register(result.getActiveRules(), result.getActiveRuleParams());
        this.descendantsLoaded = true;
    }

    public void reset(int ruleId) {
        this.doSwitch(this.baseRulesProfile, ruleId);
    }

    void selectChild(QProfileDto to) {
        Preconditions.checkState((!to.isBuiltIn() ? 1 : 0) != 0);
        QProfileDto qp = Objects.requireNonNull(this.profilesByUuid.get(to.getKee()), () -> "No profile with uuid " + to.getKee());
        RulesProfileDto ruleProfile = RulesProfileDto.from((QProfileDto)qp);
        this.doSwitch(ruleProfile, this.getRule().get().getId());
    }

    private void doSwitch(RulesProfileDto ruleProfile, int ruleId) {
        this.currentRule = this.rulesById.get(ruleId);
        WsUtils.checkRequest(this.currentRule != null, "Rule with ID %s not found", ruleId);
        RuleKey ruleKey = this.currentRule.get().getKey();
        WsUtils.checkRequest(ruleProfile.getLanguage().equals(this.currentRule.get().getLanguage()), "%s rule %s cannot be activated on %s profile %s", this.currentRule.get().getLanguage(), ruleKey, ruleProfile.getLanguage(), ruleProfile.getName());
        this.currentRulesProfile = ruleProfile;
        this.currentProfiles = this.profilesByUuid.values().stream().filter(p -> p.getRulesProfileUuid().equals(ruleProfile.getKee())).collect(Collectors.toList());
        this.currentActiveRule = this.activeRulesByKey.get(ActiveRuleKey.of((RulesProfileDto)ruleProfile, (RuleKey)ruleKey));
        this.currentParentActiveRule = this.currentProfiles.stream().map(QProfileDto::getParentKee).filter(Objects::nonNull).map(this.profilesByUuid::get).filter(Objects::nonNull).findFirst().map(profile -> this.activeRulesByKey.get(ActiveRuleKey.of((QProfileDto)profile, (RuleKey)ruleKey))).orElse(null);
    }

    static final class ActiveRuleWrapper {
        private final ActiveRuleDto activeRule;
        private final Map<String, ActiveRuleParamDto> paramsByKey;

        private ActiveRuleWrapper(ActiveRuleDto activeRule, Collection<ActiveRuleParamDto> params) {
            this.activeRule = activeRule;
            this.paramsByKey = (Map)params.stream().collect(MoreCollectors.uniqueIndex(ActiveRuleParamDto::getKey));
        }

        ActiveRuleDto get() {
            return this.activeRule;
        }

        Collection<ActiveRuleParamDto> getParams() {
            return this.paramsByKey.values();
        }

        @CheckForNull
        ActiveRuleParamDto getParam(String key) {
            return this.paramsByKey.get(key);
        }

        @CheckForNull
        String getParamValue(String key) {
            ActiveRuleParamDto param = this.paramsByKey.get(key);
            return param != null ? param.getValue() : null;
        }
    }

    static final class RuleWrapper {
        private final RuleDefinitionDto rule;
        private final Map<String, RuleParamDto> paramsByKey;

        private RuleWrapper(RuleDefinitionDto rule, Collection<RuleParamDto> params) {
            this.rule = rule;
            this.paramsByKey = (Map)params.stream().collect(MoreCollectors.uniqueIndex(RuleParamDto::getName));
        }

        RuleDefinitionDto get() {
            return this.rule;
        }

        Collection<RuleParamDto> getParams() {
            return this.paramsByKey.values();
        }

        @CheckForNull
        RuleParamDto getParam(String key) {
            return this.paramsByKey.get(key);
        }

        @CheckForNull
        String getParamDefaultValue(String key) {
            RuleParamDto param = this.getParam(key);
            return param != null ? param.getDefaultValue() : null;
        }
    }

    static final class Builder {
        private long date = System.currentTimeMillis();
        private RulesProfileDto baseRulesProfile;
        private Collection<RuleDefinitionDto> rules;
        private Collection<RuleParamDto> ruleParams;
        private Collection<QProfileDto> profiles;
        private Collection<ActiveRuleDto> activeRules;
        private Collection<ActiveRuleParamDto> activeRuleParams;
        private DescendantProfilesSupplier descendantProfilesSupplier;

        Builder() {
        }

        Builder setDate(long l) {
            this.date = l;
            return this;
        }

        Builder setBaseProfile(RulesProfileDto p) {
            this.baseRulesProfile = p;
            return this;
        }

        Builder setRules(Collection<RuleDefinitionDto> rules) {
            this.rules = rules;
            return this;
        }

        Builder setRuleParams(Collection<RuleParamDto> ruleParams) {
            this.ruleParams = ruleParams;
            return this;
        }

        Builder setProfiles(Collection<QProfileDto> profiles) {
            this.profiles = profiles;
            return this;
        }

        Builder setActiveRules(Collection<ActiveRuleDto> activeRules) {
            this.activeRules = activeRules;
            return this;
        }

        Builder setActiveRuleParams(Collection<ActiveRuleParamDto> activeRuleParams) {
            this.activeRuleParams = activeRuleParams;
            return this;
        }

        Builder setDescendantProfilesSupplier(DescendantProfilesSupplier d) {
            this.descendantProfilesSupplier = d;
            return this;
        }

        RuleActivationContext build() {
            Preconditions.checkArgument((this.date > 0L ? 1 : 0) != 0, (Object)"date is not set");
            Objects.requireNonNull(this.baseRulesProfile, "baseRulesProfile is null");
            Objects.requireNonNull(this.rules, "rules is null");
            Objects.requireNonNull(this.ruleParams, "ruleParams is null");
            Objects.requireNonNull(this.profiles, "profiles is null");
            Objects.requireNonNull(this.activeRules, "activeRules is null");
            Objects.requireNonNull(this.activeRuleParams, "activeRuleParams is null");
            Objects.requireNonNull(this.descendantProfilesSupplier, "descendantProfilesSupplier is null");
            return new RuleActivationContext(this);
        }
    }
}

