/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source.ws;

import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.source.ws.SourcesWsAction;
import org.sonar.server.user.UserSession;

public class HashAction
implements SourcesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public HashAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("hash").setDescription("Show line line hashes for a given file. Require See Source Code permission on file's project<br/>").setSince("5.0").setInternal(true).setDeprecatedSince("7.7").setResponseExample(Resources.getResource(this.getClass(), (String)"example-hash.txt")).setHandler((RequestHandler)this);
        action.createParam("key").setRequired(true).setDescription("File key").setExampleValue((Object)"my_project:/src/foo/Bar.php");
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession session = this.dbClient.openSession(false);){
            String componentKey = request.mandatoryParam("key");
            ComponentDto component = this.componentFinder.getByKey(session, componentKey);
            this.userSession.checkComponentPermission("user", component);
            response.stream().setMediaType("text/plain");
            try (OutputStreamWriter writer = new OutputStreamWriter(response.stream().output(), StandardCharsets.UTF_8);){
                HashConsumer hashFunction = new HashConsumer(writer, componentKey);
                this.dbClient.fileSourceDao().readLineHashesStream(session, component.uuid(), (Consumer)hashFunction);
                if (!hashFunction.hasData()) {
                    response.noContent();
                }
            }
        }
    }

    private static class HashConsumer
    implements Consumer<Reader> {
        private final OutputStreamWriter writer;
        private final String componentKey;
        private boolean hasData = false;

        public HashConsumer(OutputStreamWriter writer, String componentKey) {
            this.writer = writer;
            this.componentKey = componentKey;
        }

        @Override
        public void accept(Reader input) {
            try {
                this.hasData = true;
                CharStreams.copy((Readable)input, (Appendable)this.writer);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Can't read line hashes of file '%s'", this.componentKey), e);
            }
        }

        public boolean hasData() {
            return this.hasData;
        }
    }
}

