/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source.ws;

import com.google.common.io.Resources;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.protobuf.DbCommons;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.db.protobuf.DbIssues;
import org.sonar.server.component.ws.ComponentViewerJsonWriter;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.source.SourceService;
import org.sonar.server.source.ws.LinesJsonWriter;
import org.sonar.server.source.ws.SourcesWsAction;
import org.sonar.server.user.UserSession;

public class IssueSnippetsAction
implements SourcesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final SourceService sourceService;
    private final ComponentViewerJsonWriter componentViewerJsonWriter;
    private final LinesJsonWriter linesJsonWriter;

    public IssueSnippetsAction(DbClient dbClient, UserSession userSession, SourceService sourceService, LinesJsonWriter linesJsonWriter, ComponentViewerJsonWriter componentViewerJsonWriter) {
        this.sourceService = sourceService;
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.linesJsonWriter = linesJsonWriter;
        this.componentViewerJsonWriter = componentViewerJsonWriter;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("issue_snippets").setDescription("Get code snipets involved in an issue. Requires 'Browse' permission on the project<br/>").setSince("7.8").setInternal(true).setResponseExample(Resources.getResource(this.getClass(), (String)"example-show.json")).setHandler((RequestHandler)this);
        action.createParam("issueKey").setRequired(true).setDescription("Issue key").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
    }

    public void handle(Request request, Response response) throws Exception {
        block14: {
            String issueKey = request.mandatoryParam("issueKey");
            try (DbSession dbSession = this.dbClient.openSession(false);){
                IssueDto issueDto = (IssueDto)this.dbClient.issueDao().selectByKey(dbSession, issueKey).orElseThrow(() -> new NotFoundException(String.format("Issue with key '%s' does not exist", issueKey)));
                ComponentDto project = (ComponentDto)this.dbClient.componentDao().selectByUuid(dbSession, issueDto.getProjectUuid()).orElseThrow(() -> new NotFoundException(String.format("Project with uuid '%s' does not exist", issueDto.getProjectUuid())));
                this.userSession.checkComponentPermission("codeviewer", project);
                DbIssues.Locations locations = issueDto.parseLocations();
                String componentUuid = issueDto.getComponentUuid();
                if (locations == null || componentUuid == null) {
                    response.noContent();
                    break block14;
                }
                Map<String, TreeSet<Integer>> linesPerComponent = IssueSnippetsAction.getLinesPerComponent(componentUuid, locations);
                Map<String, ComponentDto> componentsByUuid = this.dbClient.componentDao().selectByUuids(dbSession, linesPerComponent.keySet()).stream().collect(Collectors.toMap(ComponentDto::uuid, c -> c));
                try (JsonWriter jsonWriter = response.newJsonWriter();){
                    jsonWriter.beginObject();
                    boolean showScmAuthors = this.userSession.hasMembership(new OrganizationDto().setUuid(project.getOrganizationUuid()));
                    for (Map.Entry<String, TreeSet<Integer>> e : linesPerComponent.entrySet()) {
                        ComponentDto componentDto = componentsByUuid.get(e.getKey());
                        if (componentDto == null) continue;
                        this.writeSnippet(dbSession, jsonWriter, componentDto, (Set<Integer>)e.getValue(), showScmAuthors);
                    }
                    jsonWriter.endObject();
                }
            }
        }
    }

    private void writeSnippet(DbSession dbSession, JsonWriter writer, ComponentDto fileDto, Set<Integer> lines, boolean showScmAuthors) {
        Optional<Iterable<DbFileSources.Line>> lineSourcesOpt = this.sourceService.getLines(dbSession, fileDto.uuid(), lines);
        if (!lineSourcesOpt.isPresent()) {
            return;
        }
        Supplier<Optional<Long>> periodDateSupplier = () -> this.dbClient.snapshotDao().selectLastAnalysisByComponentUuid(dbSession, fileDto.projectUuid()).map(SnapshotDto::getPeriodDate);
        Iterable<DbFileSources.Line> lineSources = lineSourcesOpt.get();
        writer.name(fileDto.getKey()).beginObject();
        writer.name("component").beginObject();
        this.componentViewerJsonWriter.writeComponentWithoutFav(writer, fileDto, dbSession, false);
        this.componentViewerJsonWriter.writeMeasures(writer, fileDto, dbSession);
        writer.endObject();
        this.linesJsonWriter.writeSource(lineSources, writer, showScmAuthors, periodDateSupplier);
        writer.endObject();
    }

    private static Map<String, TreeSet<Integer>> getLinesPerComponent(String componentUuid, DbIssues.Locations locations) {
        HashMap<String, TreeSet<Integer>> linesPerComponent = new HashMap<String, TreeSet<Integer>>();
        if (locations.hasTextRange()) {
            IssueSnippetsAction.addTextRange(linesPerComponent, componentUuid, locations.getTextRange(), 9);
        }
        for (DbIssues.Flow flow : locations.getFlowList()) {
            for (DbIssues.Location l : flow.getLocationList()) {
                if (l.hasComponentId()) {
                    IssueSnippetsAction.addTextRange(linesPerComponent, l.getComponentId(), l.getTextRange(), 2);
                    continue;
                }
                IssueSnippetsAction.addTextRange(linesPerComponent, componentUuid, l.getTextRange(), 2);
            }
        }
        return linesPerComponent;
    }

    private static void addTextRange(Map<String, TreeSet<Integer>> linesPerComponent, String componentUuid, DbCommons.TextRange textRange, int numLinesAfterIssue) {
        Integer closestToEnd;
        int start = textRange.getStartLine() - 2;
        int end = textRange.getEndLine() + numLinesAfterIssue;
        TreeSet lines = linesPerComponent.computeIfAbsent(componentUuid, c -> new TreeSet());
        IntStream.rangeClosed(start, end).forEach(lines::add);
        Integer closestToStart = lines.lower(start);
        if (closestToStart != null && closestToStart >= start - 4) {
            IntStream.range(closestToStart + 1, start).forEach(lines::add);
        }
        if ((closestToEnd = lines.higher(end)) != null && closestToEnd <= end + 4) {
            IntStream.range(end + 1, closestToEnd).forEach(lines::add);
        }
    }
}

