/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source.ws;

import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.source.HtmlSourceDecorator;

public class LinesJsonWriter {
    private final HtmlSourceDecorator htmlSourceDecorator;

    public LinesJsonWriter(HtmlSourceDecorator htmlSourceDecorator) {
        this.htmlSourceDecorator = htmlSourceDecorator;
    }

    public void writeSource(Iterable<DbFileSources.Line> lines, JsonWriter json, boolean showScmAuthors, Supplier<Optional<Long>> periodDateSupplier) {
        Optional<Long> periodDate = null;
        json.name("sources").beginArray();
        for (DbFileSources.Line line : lines) {
            Optional<Integer> coveredConditions;
            Optional<Integer> conditions;
            Optional<Integer> lineHits;
            json.beginObject().prop("line", (long)line.getLine()).prop("code", this.htmlSourceDecorator.getDecoratedSourceAsHtml(line.getSource(), line.getHighlighting(), line.getSymbols())).prop("scmRevision", line.getScmRevision());
            if (showScmAuthors) {
                json.prop("scmAuthor", line.getScmAuthor());
            }
            if (line.hasScmDate()) {
                json.prop("scmDate", DateUtils.formatDateTime((Date)new Date(line.getScmDate())));
            }
            if ((lineHits = LinesJsonWriter.getLineHits(line)).isPresent()) {
                json.prop("utLineHits", (Number)lineHits.get());
                json.prop("lineHits", (Number)lineHits.get());
            }
            if ((conditions = LinesJsonWriter.getConditions(line)).isPresent()) {
                json.prop("utConditions", (Number)conditions.get());
                json.prop("conditions", (Number)conditions.get());
            }
            if ((coveredConditions = LinesJsonWriter.getCoveredConditions(line)).isPresent()) {
                json.prop("utCoveredConditions", (Number)coveredConditions.get());
                json.prop("coveredConditions", (Number)coveredConditions.get());
            }
            json.prop("duplicated", line.getDuplicationCount() > 0);
            if (line.hasIsNewLine()) {
                json.prop("isNew", line.getIsNewLine());
            } else {
                if (periodDate == null) {
                    periodDate = periodDateSupplier.get();
                }
                json.prop("isNew", periodDate.isPresent() && line.getScmDate() > periodDate.get());
            }
            json.endObject();
        }
        json.endArray();
    }

    private static Optional<Integer> getLineHits(DbFileSources.Line line) {
        if (line.hasLineHits()) {
            return Optional.of(line.getLineHits());
        }
        if (line.hasDeprecatedOverallLineHits()) {
            return Optional.of(line.getDeprecatedOverallLineHits());
        }
        if (line.hasDeprecatedUtLineHits()) {
            return Optional.of(line.getDeprecatedUtLineHits());
        }
        if (line.hasDeprecatedItLineHits()) {
            return Optional.of(line.getDeprecatedItLineHits());
        }
        return Optional.empty();
    }

    private static Optional<Integer> getConditions(DbFileSources.Line line) {
        if (line.hasConditions()) {
            return Optional.of(line.getConditions());
        }
        if (line.hasDeprecatedOverallConditions()) {
            return Optional.of(line.getDeprecatedOverallConditions());
        }
        if (line.hasDeprecatedUtConditions()) {
            return Optional.of(line.getDeprecatedUtConditions());
        }
        if (line.hasDeprecatedItConditions()) {
            return Optional.of(line.getDeprecatedItConditions());
        }
        return Optional.empty();
    }

    private static Optional<Integer> getCoveredConditions(DbFileSources.Line line) {
        if (line.hasCoveredConditions()) {
            return Optional.of(line.getCoveredConditions());
        }
        if (line.hasDeprecatedOverallCoveredConditions()) {
            return Optional.of(line.getDeprecatedOverallCoveredConditions());
        }
        if (line.hasDeprecatedUtCoveredConditions()) {
            return Optional.of(line.getDeprecatedUtCoveredConditions());
        }
        if (line.hasDeprecatedItCoveredConditions()) {
            return Optional.of(line.getDeprecatedItCoveredConditions());
        }
        return Optional.empty();
    }
}

