/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.startup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.sonar.api.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.platform.ServerFileSystem;
import org.sonar.server.plugins.InstalledPlugin;
import org.sonar.server.plugins.PluginFileSystem;

@ServerSide
public final class GeneratePluginIndex
implements Startable {
    private static final Logger LOG = Loggers.get(GeneratePluginIndex.class);
    private final ServerFileSystem serverFs;
    private final PluginFileSystem pluginFs;

    public GeneratePluginIndex(ServerFileSystem serverFs, PluginFileSystem pluginFs) {
        this.serverFs = serverFs;
        this.pluginFs = pluginFs;
    }

    public void start() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Generate scanner plugin index");
        this.writeIndex(this.serverFs.getPluginIndex());
        profiler.stopDebug();
    }

    public void stop() {
    }

    private void writeIndex(File indexFile) {
        try {
            FileUtils.forceMkdir((File)indexFile.getParentFile());
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(indexFile), StandardCharsets.UTF_8);){
                for (InstalledPlugin plugin : this.pluginFs.getInstalledFiles()) {
                    ((Writer)writer).append(GeneratePluginIndex.toRow(plugin));
                    writer.append('\n');
                }
                ((Writer)writer).flush();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to generate plugin index at " + indexFile, e);
        }
    }

    private static String toRow(InstalledPlugin file) {
        StringBuilder sb = new StringBuilder();
        sb.append(file.getPluginInfo().getKey()).append(",").append(file.getPluginInfo().isSonarLintSupported()).append(",").append(file.getLoadedJar().getFile().getName()).append("|").append(file.getLoadedJar().getMd5());
        return sb.toString();
    }
}

