/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.startup;

import java.util.Date;
import java.util.Optional;
import org.picocontainer.Startable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.DefaultTemplates;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.db.user.GroupDto;
import org.sonar.server.organization.DefaultOrganizationProvider;

public class RegisterPermissionTemplates
implements Startable {
    private static final Logger LOG = Loggers.get(RegisterPermissionTemplates.class);
    private static final String DEFAULT_TEMPLATE_UUID = "default_template";
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public RegisterPermissionTemplates(DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void start() {
        Profiler profiler = Profiler.create((Logger)Loggers.get(this.getClass())).startInfo("Register permission templates");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String defaultOrganizationUuid = this.defaultOrganizationProvider.get().getUuid();
            Optional defaultTemplates = this.dbClient.organizationDao().getDefaultTemplates(dbSession, defaultOrganizationUuid);
            if (!defaultTemplates.isPresent()) {
                PermissionTemplateDto defaultTemplate = this.getOrInsertDefaultTemplate(dbSession, defaultOrganizationUuid);
                this.dbClient.organizationDao().setDefaultTemplates(dbSession, defaultOrganizationUuid, new DefaultTemplates().setProjectUuid(defaultTemplate.getUuid()));
                dbSession.commit();
            }
        }
        profiler.stopDebug();
    }

    public void stop() {
    }

    private PermissionTemplateDto getOrInsertDefaultTemplate(DbSession dbSession, String defaultOrganizationUuid) {
        PermissionTemplateDto permissionTemplateDto = this.dbClient.permissionTemplateDao().selectByUuid(dbSession, DEFAULT_TEMPLATE_UUID);
        if (permissionTemplateDto != null) {
            return permissionTemplateDto;
        }
        PermissionTemplateDto template = new PermissionTemplateDto().setOrganizationUuid(defaultOrganizationUuid).setName("Default template").setUuid(DEFAULT_TEMPLATE_UUID).setDescription("This permission template will be used as default when no other permission configuration is available").setCreatedAt(new Date()).setUpdatedAt(new Date());
        this.dbClient.permissionTemplateDao().insert(dbSession, template);
        this.insertDefaultGroupPermissions(dbSession, template);
        dbSession.commit();
        return template;
    }

    private void insertDefaultGroupPermissions(DbSession dbSession, PermissionTemplateDto template) {
        this.insertPermissionForAdministrators(dbSession, template);
        this.insertPermissionsForDefaultGroup(dbSession, template);
    }

    private void insertPermissionForAdministrators(DbSession dbSession, PermissionTemplateDto template) {
        Optional admins = this.dbClient.groupDao().selectByName(dbSession, template.getOrganizationUuid(), "sonar-administrators");
        if (admins.isPresent()) {
            this.insertGroupPermission(dbSession, template, "admin", (GroupDto)admins.get());
            this.insertGroupPermission(dbSession, template, OrganizationPermission.APPLICATION_CREATOR.getKey(), (GroupDto)admins.get());
            this.insertGroupPermission(dbSession, template, OrganizationPermission.PORTFOLIO_CREATOR.getKey(), (GroupDto)admins.get());
        } else {
            LOG.error("Cannot setup default permission for group: sonar-administrators");
        }
    }

    private void insertPermissionsForDefaultGroup(DbSession dbSession, PermissionTemplateDto template) {
        String organizationUuid = template.getOrganizationUuid();
        Integer defaultGroupId = (Integer)this.dbClient.organizationDao().getDefaultGroupId(dbSession, organizationUuid).orElseThrow(() -> new IllegalStateException(String.format("Default group for organization %s is not defined", organizationUuid)));
        GroupDto defaultGroup = Optional.ofNullable(this.dbClient.groupDao().selectById(dbSession, defaultGroupId.intValue())).orElseThrow(() -> new IllegalStateException(String.format("Default group with id %s for organization %s doesn't exist", defaultGroupId, organizationUuid)));
        this.insertGroupPermission(dbSession, template, "user", defaultGroup);
        this.insertGroupPermission(dbSession, template, "codeviewer", defaultGroup);
        this.insertGroupPermission(dbSession, template, "issueadmin", defaultGroup);
        this.insertGroupPermission(dbSession, template, "securityhotspotadmin", defaultGroup);
    }

    private void insertGroupPermission(DbSession dbSession, PermissionTemplateDto template, String permission, GroupDto group) {
        this.dbClient.permissionTemplateDao().insertGroupPermission(dbSession, template.getId().longValue(), group.getId(), permission);
    }
}

