/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.updatecenter.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.platform.PluginInfo;
import org.sonar.server.plugins.ServerPluginRepository;
import org.sonar.server.updatecenter.ws.UpdateCenterWsAction;
import org.sonar.updatecenter.common.Version;

public class InstalledPluginsAction
implements UpdateCenterWsAction {
    private final ServerPluginRepository pluginRepository;

    public InstalledPluginsAction(ServerPluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("installed_plugins").setDescription("Get the list of all the plugins installed on the SonarQube instance").setSince("2.10").setDeprecatedSince("6.3").setInternal(true).setResponseExample(this.getClass().getResource("installed_plugins-example.json")).setHandler((RequestHandler)this);
        action.createParam("format").setDescription("Only json response format is available").setPossibleValues((Object[])new String[]{"json"});
    }

    public void handle(Request request, Response response) throws Exception {
        try (JsonWriter json = response.newJsonWriter();){
            json.beginArray();
            for (PluginInfo pluginInfo : this.pluginRepository.getPluginInfos()) {
                Version version = pluginInfo.getVersion();
                json.beginObject().prop("key", pluginInfo.getKey()).prop("name", pluginInfo.getName());
                if (version != null) {
                    json.prop("version", version.getName());
                }
                json.endObject();
            }
            json.endArray().close();
        }
    }
}

