/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.ThreadLocalUserSession;
import org.sonar.server.user.UserSession;

public final class DoPrivileged {
    private DoPrivileged() {
    }

    public static void execute(Task task) {
        try {
            task.start();
            task.doPrivileged();
        }
        finally {
            task.stop();
        }
    }

    public static abstract class Task {
        private final ThreadLocalUserSession threadLocalUserSession;
        private UserSession oldUserSession;

        protected Task(ThreadLocalUserSession threadLocalUserSession) {
            this.threadLocalUserSession = threadLocalUserSession;
        }

        protected abstract void doPrivileged();

        private void start() {
            this.oldUserSession = this.threadLocalUserSession.hasSession() ? this.threadLocalUserSession.get() : null;
            this.threadLocalUserSession.set(new PrivilegedUserSession());
        }

        private void stop() {
            this.threadLocalUserSession.unload();
            if (this.oldUserSession != null) {
                this.threadLocalUserSession.set(this.oldUserSession);
            }
        }

        private static class PrivilegedUserSession
        extends AbstractUserSession {
            private PrivilegedUserSession() {
            }

            @Override
            public String getLogin() {
                return null;
            }

            @Override
            public String getUuid() {
                return null;
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public Integer getUserId() {
                return null;
            }

            @Override
            public Collection<GroupDto> getGroups() {
                return Collections.emptyList();
            }

            @Override
            public boolean isLoggedIn() {
                return false;
            }

            @Override
            public boolean isRoot() {
                return true;
            }

            @Override
            public Optional<UserSession.IdentityProvider> getIdentityProvider() {
                return Optional.empty();
            }

            @Override
            public Optional<UserSession.ExternalIdentity> getExternalIdentity() {
                return Optional.empty();
            }

            @Override
            public Optional<String> getPersonalOrganizationUuid() {
                return Optional.empty();
            }

            @Override
            protected boolean hasPermissionImpl(OrganizationPermission permission, String organizationUuid) {
                return true;
            }

            @Override
            protected Optional<String> componentUuidToProjectUuid(String componentUuid) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected boolean hasProjectUuidPermission(String permission, String projectUuid) {
                return true;
            }

            @Override
            public boolean isSystemAdministrator() {
                return true;
            }

            @Override
            public boolean hasMembershipImpl(OrganizationDto organizationDto) {
                return true;
            }
        }
    }
}

