/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;

public interface UserSession {
    @CheckForNull
    public String getLogin();

    @CheckForNull
    public String getUuid();

    @CheckForNull
    public String getName();

    @CheckForNull
    public Integer getUserId();

    public Collection<GroupDto> getGroups();

    public Optional<IdentityProvider> getIdentityProvider();

    public Optional<ExternalIdentity> getExternalIdentity();

    public Optional<String> getPersonalOrganizationUuid();

    public boolean isLoggedIn();

    public boolean isRoot();

    public UserSession checkIsRoot();

    public UserSession checkLoggedIn();

    public boolean hasPermission(OrganizationPermission var1, OrganizationDto var2);

    public boolean hasPermission(OrganizationPermission var1, String var2);

    public UserSession checkPermission(OrganizationPermission var1, OrganizationDto var2);

    public UserSession checkPermission(OrganizationPermission var1, String var2);

    public boolean hasComponentPermission(String var1, ComponentDto var2);

    @Deprecated
    public boolean hasComponentUuidPermission(String var1, String var2);

    public List<ComponentDto> keepAuthorizedComponents(String var1, Collection<ComponentDto> var2);

    public UserSession checkComponentPermission(String var1, ComponentDto var2);

    @Deprecated
    public UserSession checkComponentUuidPermission(String var1, String var2);

    public boolean isSystemAdministrator();

    public UserSession checkIsSystemAdministrator();

    public boolean hasMembership(OrganizationDto var1);

    public UserSession checkMembership(OrganizationDto var1);

    @Immutable
    public static final class ExternalIdentity {
        private final String id;
        private final String login;

        public ExternalIdentity(String id, String login) {
            this.id = Objects.requireNonNull(id, "id can't be null");
            this.login = Objects.requireNonNull(login, "login can't be null");
        }

        public String getId() {
            return this.id;
        }

        public String getLogin() {
            return this.login;
        }

        public String toString() {
            return "ExternalIdentity{id='" + this.id + '\'' + ", login='" + this.login + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalIdentity that = (ExternalIdentity)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.login, that.login);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.login);
        }
    }

    public static enum IdentityProvider {
        SONARQUBE("sonarqube"),
        GITHUB("github"),
        BITBUCKETCLOUD("bitbucket"),
        OTHER("other");

        String key;

        private IdentityProvider(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static IdentityProvider getFromKey(String key) {
            return Arrays.stream(IdentityProvider.values()).filter(i -> i.getKey().equals(key)).findAny().orElse(OTHER);
        }
    }
}

