/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.CredentialsLocalAuthentication;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.authentication.event.AuthenticationException;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.user.UpdateUser;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.UserUpdater;
import org.sonar.server.user.ws.UsersWsAction;

public class ChangePasswordAction
implements UsersWsAction {
    private static final String PARAM_LOGIN = "login";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_PREVIOUS_PASSWORD = "previousPassword";
    private final DbClient dbClient;
    private final UserUpdater userUpdater;
    private final UserSession userSession;
    private final CredentialsLocalAuthentication localAuthentication;

    public ChangePasswordAction(DbClient dbClient, UserUpdater userUpdater, UserSession userSession, CredentialsLocalAuthentication localAuthentication) {
        this.dbClient = dbClient;
        this.userUpdater = userUpdater;
        this.userSession = userSession;
        this.localAuthentication = localAuthentication;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("change_password").setDescription("Update a user's password. Authenticated users can change their own password, provided that the account is not linked to an external authentication system. Administer System permission is required to change another user's password.").setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_LOGIN).setDescription("User login").setRequired(true).setExampleValue((Object)"myuser");
        action.createParam(PARAM_PASSWORD).setDescription("New password").setRequired(true).setExampleValue((Object)"mypassword");
        action.createParam(PARAM_PREVIOUS_PASSWORD).setDescription("Previous password. Required when changing one's own password.").setRequired(false).setExampleValue((Object)"oldpassword");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String login = request.mandatoryParam(PARAM_LOGIN);
            UserDto user = this.getUser(dbSession, login);
            if (login.equals(this.userSession.getLogin())) {
                String previousPassword = request.mandatoryParam(PARAM_PREVIOUS_PASSWORD);
                this.checkCurrentPassword(dbSession, user, previousPassword);
            } else {
                this.userSession.checkIsSystemAdministrator();
            }
            String password = request.mandatoryParam(PARAM_PASSWORD);
            UpdateUser updateUser = new UpdateUser().setPassword(password);
            this.userUpdater.updateAndCommit(dbSession, user, updateUser, u -> {}, new UserDto[0]);
        }
        response.noContent();
    }

    private UserDto getUser(DbSession dbSession, String login) {
        UserDto user = this.dbClient.userDao().selectByLogin(dbSession, login);
        if (user == null || !user.isActive()) {
            throw new NotFoundException(String.format("User with login '%s' has not been found", login));
        }
        return user;
    }

    private void checkCurrentPassword(DbSession dbSession, UserDto user, String password) {
        try {
            this.localAuthentication.authenticate(dbSession, user, password, AuthenticationEvent.Method.BASIC);
        }
        catch (AuthenticationException ex) {
            throw new IllegalArgumentException("Incorrect password");
        }
    }
}

