/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.protobuf.Message;
import java.util.Optional;
import java.util.function.Function;
import org.sonar.api.server.authentication.Display;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.authentication.IdentityProviderRepository;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Users;

public class IdentityProvidersAction
implements UsersWsAction {
    private final IdentityProviderRepository identityProviderRepository;

    public IdentityProvidersAction(IdentityProviderRepository identityProviderRepository) {
        this.identityProviderRepository = identityProviderRepository;
    }

    public void define(WebService.NewController context) {
        context.createAction("identity_providers").setDescription("List the external identity providers").setResponseExample(this.getClass().getResource("identity_providers-example.json")).setSince("5.5").setInternal(true).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        WsUtils.writeProtobuf((Message)this.buildResponse(), request, response);
    }

    private Users.IdentityProvidersWsResponse buildResponse() {
        Users.IdentityProvidersWsResponse.Builder response = Users.IdentityProvidersWsResponse.newBuilder();
        response.addAllIdentityProviders((Iterable)this.identityProviderRepository.getAllEnabledAndSorted().stream().map(IdentityProvidersAction.toWsIdentityProvider()).collect(MoreCollectors.toList()));
        return response.build();
    }

    private static Function<IdentityProvider, Users.IdentityProvider> toWsIdentityProvider() {
        return input -> {
            Display display = input.getDisplay();
            Users.IdentityProvider.Builder builder = Users.IdentityProvider.newBuilder().setKey(input.getKey()).setName(input.getName()).setIconPath(display.getIconPath()).setBackgroundColor(display.getBackgroundColor());
            Optional.ofNullable(display.getHelpMessage()).ifPresent(arg_0 -> ((Users.IdentityProvider.Builder)builder).setHelpMessage(arg_0));
            return builder.build();
        };
    }
}

