/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.ws.HomepageTypes;
import org.sonar.server.user.ws.UsersWsAction;

public class SetHomepageAction
implements UsersWsAction {
    private static final String ACTION = "set_homepage";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_ORGANIZATION = "organization";
    public static final String PARAM_COMPONENT = "component";
    public static final String PARAM_BRANCH = "branch";
    private static final String PARAMETER_REQUIRED = "Type %s requires a parameter '%s'";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;

    public SetHomepageAction(UserSession userSession, DbClient dbClient, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction(ACTION).setPost(true).setInternal(true).setDescription("Set homepage of current user.<br> Requires authentication.").setSince("7.0").setChangelog(new Change[]{new Change("7.1", "Parameter 'parameter' is replaced by 'component' and 'organization'")}).setHandler((RequestHandler)this);
        action.createParam(PARAM_TYPE).setDescription("Type of the requested page").setRequired(true).setPossibleValues((Object[])HomepageTypes.Type.values());
        action.createParam(PARAM_ORGANIZATION).setDescription("Organization key. It should only be used when parameter '%s' is set to '%s'", new Object[]{PARAM_TYPE, HomepageTypes.Type.ORGANIZATION}).setSince("7.1").setExampleValue((Object)"my-org");
        action.createParam(PARAM_COMPONENT).setSince("7.1").setDescription("Project key. It should only be used when parameter '%s' is set to '%s'", new Object[]{PARAM_TYPE, HomepageTypes.Type.PROJECT}).setExampleValue((Object)"my_project");
        action.createParam(PARAM_BRANCH).setDescription("Branch key. It can only be used when parameter '%s' is set to '%s'", new Object[]{PARAM_TYPE, HomepageTypes.Type.PROJECT}).setExampleValue((Object)"feature/my_branch").setSince("7.1");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        HomepageTypes.Type type = (HomepageTypes.Type)request.mandatoryParamAsEnum(PARAM_TYPE, HomepageTypes.Type.class);
        String componentParameter = request.param(PARAM_COMPONENT);
        String organizationParameter = request.param(PARAM_ORGANIZATION);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String parameter = this.getHomepageParameter(dbSession, type, componentParameter, request.param(PARAM_BRANCH), organizationParameter);
            UserDto user = this.dbClient.userDao().selectActiveUserByLogin(dbSession, this.userSession.getLogin());
            Preconditions.checkState((user != null ? 1 : 0) != 0, (String)"User login '%s' cannot be found", (Object[])new Object[]{this.userSession.getLogin()});
            user.setHomepageType(type.name());
            user.setHomepageParameter(parameter);
            this.dbClient.userDao().update(dbSession, user);
            dbSession.commit();
        }
        response.noContent();
    }

    @CheckForNull
    private String getHomepageParameter(DbSession dbSession, HomepageTypes.Type type, @Nullable String componentParameter, @Nullable String branchParameter, @Nullable String organizationParameter) {
        switch (type) {
            case PROJECT: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)componentParameter), (String)PARAMETER_REQUIRED, (Object[])new Object[]{type.name(), PARAM_COMPONENT});
                return this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, componentParameter, branchParameter, null).uuid();
            }
            case PORTFOLIO: 
            case APPLICATION: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)componentParameter), (String)PARAMETER_REQUIRED, (Object[])new Object[]{type.name(), PARAM_COMPONENT});
                return this.componentFinder.getByKey(dbSession, componentParameter).uuid();
            }
            case ORGANIZATION: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)organizationParameter), (String)PARAMETER_REQUIRED, (Object[])new Object[]{type.name(), PARAM_ORGANIZATION});
                return ((OrganizationDto)this.dbClient.organizationDao().selectByKey(dbSession, organizationParameter).orElseThrow(() -> new NotFoundException(String.format("No organizationDto with key '%s'", organizationParameter)))).getUuid();
            }
            case PORTFOLIOS: 
            case PROJECTS: 
            case ISSUES: 
            case MY_PROJECTS: 
            case MY_ISSUES: {
                Preconditions.checkArgument((boolean)StringUtils.isBlank((String)componentParameter), (String)"Parameter '%s' must not be provided when type is '%s'", (Object[])new Object[]{PARAM_COMPONENT, type.name()});
                Preconditions.checkArgument((boolean)StringUtils.isBlank((String)organizationParameter), (String)"Parameter '%s' must not be provided when type is '%s'", (Object[])new Object[]{PARAM_ORGANIZATION, type.name()});
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown type '%s'", type.name()));
    }
}

