/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups.ws;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.user.GroupDto;

@Immutable
public class GroupIdOrAnyone {
    private final Integer id;
    private final String organizationUuid;

    private GroupIdOrAnyone(String organizationUuid, @Nullable Integer id) {
        this.id = id;
        this.organizationUuid = Objects.requireNonNull(organizationUuid);
    }

    public boolean isAnyone() {
        return this.id == null;
    }

    @CheckForNull
    public Integer getId() {
        return this.id;
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public static GroupIdOrAnyone from(GroupDto dto) {
        return new GroupIdOrAnyone(dto.getOrganizationUuid(), dto.getId());
    }

    public static GroupIdOrAnyone forAnyone(String organizationUuid) {
        return new GroupIdOrAnyone(organizationUuid, null);
    }
}

